// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeFlowSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeNetworkSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeSourceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateBridgeSourceOperationSerializer: HttpSerializer.NonStreaming<UpdateBridgeSourceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateBridgeSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.bridgeArn) { "bridgeArn is bound to the URI and must not be null" }
            requireNotNull(input.sourceName) { "sourceName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("bridges"))
                add(PercentEncoding.SmithyLabel.encode(input.bridgeArn))
                add(PercentEncoding.Path.encode("sources"))
                add(PercentEncoding.SmithyLabel.encode(input.sourceName))
            }
        }

        val payload = serializeUpdateBridgeSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBridgeSourceOperationBody(context: ExecutionContext, input: UpdateBridgeSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val FLOWSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("flowSource"))
    val NETWORKSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("networkSource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLOWSOURCE_DESCRIPTOR)
        field(NETWORKSOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.flowSource?.let { field(FLOWSOURCE_DESCRIPTOR, it, ::serializeUpdateBridgeFlowSourceRequestDocument) }
        input.networkSource?.let { field(NETWORKSOURCE_DESCRIPTOR, it, ::serializeUpdateBridgeNetworkSourceRequestDocument) }
    }
    return serializer.toByteArray()
}
