// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for an instance in a gateway.
 */
public class GatewayInstance private constructor(builder: Builder) {
    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be deployed to this instance.
     */
    public val bridgePlacement: aws.sdk.kotlin.services.mediaconnect.model.BridgePlacement? = builder.bridgePlacement
    /**
     * The connection state of the instance.
     */
    public val connectionStatus: aws.sdk.kotlin.services.mediaconnect.model.ConnectionStatus? = builder.connectionStatus
    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The ARN of the gateway.
     */
    public val gatewayInstanceArn: kotlin.String? = builder.gatewayInstanceArn
    /**
     * The instance ID generated by the SSM install. This will begin with "mi-".
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Messages with information about the gateway.
     */
    public val instanceMessages: List<MessageDetail>? = builder.instanceMessages
    /**
     * The status of the instance.
     */
    public val instanceState: aws.sdk.kotlin.services.mediaconnect.model.InstanceState? = builder.instanceState
    /**
     * The running bridge count.
     */
    public val runningBridgeCount: kotlin.Int? = builder.runningBridgeCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.GatewayInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayInstance(")
        append("bridgePlacement=$bridgePlacement,")
        append("connectionStatus=$connectionStatus,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayInstanceArn=$gatewayInstanceArn,")
        append("instanceId=$instanceId,")
        append("instanceMessages=$instanceMessages,")
        append("instanceState=$instanceState,")
        append("runningBridgeCount=$runningBridgeCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bridgePlacement?.hashCode() ?: 0
        result = 31 * result + (connectionStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceMessages?.hashCode() ?: 0)
        result = 31 * result + (instanceState?.hashCode() ?: 0)
        result = 31 * result + (runningBridgeCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayInstance

        if (bridgePlacement != other.bridgePlacement) return false
        if (connectionStatus != other.connectionStatus) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayInstanceArn != other.gatewayInstanceArn) return false
        if (instanceId != other.instanceId) return false
        if (instanceMessages != other.instanceMessages) return false
        if (instanceState != other.instanceState) return false
        if (runningBridgeCount != other.runningBridgeCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.GatewayInstance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be deployed to this instance.
         */
        public var bridgePlacement: aws.sdk.kotlin.services.mediaconnect.model.BridgePlacement? = null
        /**
         * The connection state of the instance.
         */
        public var connectionStatus: aws.sdk.kotlin.services.mediaconnect.model.ConnectionStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the instance.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The ARN of the gateway.
         */
        public var gatewayInstanceArn: kotlin.String? = null
        /**
         * The instance ID generated by the SSM install. This will begin with "mi-".
         */
        public var instanceId: kotlin.String? = null
        /**
         * Messages with information about the gateway.
         */
        public var instanceMessages: List<MessageDetail>? = null
        /**
         * The status of the instance.
         */
        public var instanceState: aws.sdk.kotlin.services.mediaconnect.model.InstanceState? = null
        /**
         * The running bridge count.
         */
        public var runningBridgeCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.GatewayInstance) : this() {
            this.bridgePlacement = x.bridgePlacement
            this.connectionStatus = x.connectionStatus
            this.gatewayArn = x.gatewayArn
            this.gatewayInstanceArn = x.gatewayInstanceArn
            this.instanceId = x.instanceId
            this.instanceMessages = x.instanceMessages
            this.instanceState = x.instanceState
            this.runningBridgeCount = x.runningBridgeCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.GatewayInstance = GatewayInstance(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
