// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for a gateway, including its networks.
 */
public class Gateway private constructor(builder: Builder) {
    /**
     * The range of IP addresses that contribute content or initiate output requests for flows communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public val egressCidrBlocks: List<String>? = builder.egressCidrBlocks
    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Messages with information about the gateway.
     */
    public val gatewayMessages: List<MessageDetail>? = builder.gatewayMessages
    /**
     * The current status of the gateway.
     */
    public val gatewayState: aws.sdk.kotlin.services.mediaconnect.model.GatewayState? = builder.gatewayState
    /**
     * The name of the gateway. This name can not be modified after the gateway is created.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of networks in the gateway.
     */
    public val networks: List<GatewayNetwork>? = builder.networks

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Gateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Gateway(")
        append("egressCidrBlocks=$egressCidrBlocks,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayMessages=$gatewayMessages,")
        append("gatewayState=$gatewayState,")
        append("name=$name,")
        append("networks=$networks")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = egressCidrBlocks?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayMessages?.hashCode() ?: 0)
        result = 31 * result + (gatewayState?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networks?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Gateway

        if (egressCidrBlocks != other.egressCidrBlocks) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayMessages != other.gatewayMessages) return false
        if (gatewayState != other.gatewayState) return false
        if (name != other.name) return false
        if (networks != other.networks) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Gateway = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The range of IP addresses that contribute content or initiate output requests for flows communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        public var egressCidrBlocks: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Messages with information about the gateway.
         */
        public var gatewayMessages: List<MessageDetail>? = null
        /**
         * The current status of the gateway.
         */
        public var gatewayState: aws.sdk.kotlin.services.mediaconnect.model.GatewayState? = null
        /**
         * The name of the gateway. This name can not be modified after the gateway is created.
         */
        public var name: kotlin.String? = null
        /**
         * The list of networks in the gateway.
         */
        public var networks: List<GatewayNetwork>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Gateway) : this() {
            this.egressCidrBlocks = x.egressCidrBlocks
            this.gatewayArn = x.gatewayArn
            this.gatewayMessages = x.gatewayMessages
            this.gatewayState = x.gatewayState
            this.name = x.name
            this.networks = x.networks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Gateway = Gateway(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
