// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for a flow, including its source, outputs, and entitlements.
 */
public class Flow private constructor(builder: Builder) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current Amazon Web Services Region.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * A description of the flow. This value is not used or seen outside of the current MediaConnect account.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The IP address from which video will be sent to output destinations.
     */
    public val egressIp: kotlin.String? = builder.egressIp
    /**
     * The entitlements in this flow.
     */
    public val entitlements: List<Entitlement>? = builder.entitlements
    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    public val flowArn: kotlin.String? = builder.flowArn
    /**
     * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you want to enable NDI outputs on the flow.
     */
    public val flowSize: aws.sdk.kotlin.services.mediaconnect.model.FlowSize? = builder.flowSize
    /**
     * The maintenance settings for the flow.
     */
    public val maintenance: aws.sdk.kotlin.services.mediaconnect.model.Maintenance? = builder.maintenance
    /**
     * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
     */
    public val mediaStreams: List<MediaStream>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     */
    public val ndiConfig: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig? = builder.ndiConfig
    /**
     * The outputs in this flow.
     */
    public val outputs: List<Output>? = builder.outputs
    /**
     * The source for the flow.
     */
    public val source: aws.sdk.kotlin.services.mediaconnect.model.Source? = builder.source
    /**
     * The settings for the source failover.
     */
    public val sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = builder.sourceFailoverConfig
    /**
     * The settings for source monitoring.
     */
    public val sourceMonitoringConfig: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig? = builder.sourceMonitoringConfig
    /**
     * The settings for the sources that are assigned to the flow.
     */
    public val sources: List<Source>? = builder.sources
    /**
     * The current status of the flow.
     */
    public val status: aws.sdk.kotlin.services.mediaconnect.model.Status? = builder.status
    /**
     * The VPC Interfaces for this flow.
     */
    public val vpcInterfaces: List<VpcInterface>? = builder.vpcInterfaces

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Flow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Flow(")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("egressIp=$egressIp,")
        append("entitlements=$entitlements,")
        append("flowArn=$flowArn,")
        append("flowSize=$flowSize,")
        append("maintenance=$maintenance,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("ndiConfig=$ndiConfig,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sourceMonitoringConfig=$sourceMonitoringConfig,")
        append("sources=$sources,")
        append("status=$status,")
        append("vpcInterfaces=$vpcInterfaces")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (egressIp?.hashCode() ?: 0)
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (flowSize?.hashCode() ?: 0)
        result = 31 * result + (maintenance?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ndiConfig?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceMonitoringConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Flow

        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (egressIp != other.egressIp) return false
        if (entitlements != other.entitlements) return false
        if (flowArn != other.flowArn) return false
        if (flowSize != other.flowSize) return false
        if (maintenance != other.maintenance) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (ndiConfig != other.ndiConfig) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sourceMonitoringConfig != other.sourceMonitoringConfig) return false
        if (sources != other.sources) return false
        if (status != other.status) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Flow = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current Amazon Web Services Region.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * A description of the flow. This value is not used or seen outside of the current MediaConnect account.
         */
        public var description: kotlin.String? = null
        /**
         * The IP address from which video will be sent to output destinations.
         */
        public var egressIp: kotlin.String? = null
        /**
         * The entitlements in this flow.
         */
        public var entitlements: List<Entitlement>? = null
        /**
         * The Amazon Resource Name (ARN) of the flow.
         */
        public var flowArn: kotlin.String? = null
        /**
         * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you want to enable NDI outputs on the flow.
         */
        public var flowSize: aws.sdk.kotlin.services.mediaconnect.model.FlowSize? = null
        /**
         * The maintenance settings for the flow.
         */
        public var maintenance: aws.sdk.kotlin.services.mediaconnect.model.Maintenance? = null
        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
         */
        public var mediaStreams: List<MediaStream>? = null
        /**
         * The name of the flow.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         */
        public var ndiConfig: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig? = null
        /**
         * The outputs in this flow.
         */
        public var outputs: List<Output>? = null
        /**
         * The source for the flow.
         */
        public var source: aws.sdk.kotlin.services.mediaconnect.model.Source? = null
        /**
         * The settings for the source failover.
         */
        public var sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = null
        /**
         * The settings for source monitoring.
         */
        public var sourceMonitoringConfig: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig? = null
        /**
         * The settings for the sources that are assigned to the flow.
         */
        public var sources: List<Source>? = null
        /**
         * The current status of the flow.
         */
        public var status: aws.sdk.kotlin.services.mediaconnect.model.Status? = null
        /**
         * The VPC Interfaces for this flow.
         */
        public var vpcInterfaces: List<VpcInterface>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Flow) : this() {
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.egressIp = x.egressIp
            this.entitlements = x.entitlements
            this.flowArn = x.flowArn
            this.flowSize = x.flowSize
            this.maintenance = x.maintenance
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.ndiConfig = x.ndiConfig
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sourceMonitoringConfig = x.sourceMonitoringConfig
            this.sources = x.sources
            this.status = x.status
            this.vpcInterfaces = x.vpcInterfaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Flow = Flow(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Maintenance] inside the given [block]
         */
        public fun maintenance(block: aws.sdk.kotlin.services.mediaconnect.model.Maintenance.Builder.() -> kotlin.Unit) {
            this.maintenance = aws.sdk.kotlin.services.mediaconnect.model.Maintenance.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.NdiConfig] inside the given [block]
         */
        public fun ndiConfig(block: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig.Builder.() -> kotlin.Unit) {
            this.ndiConfig = aws.sdk.kotlin.services.mediaconnect.model.NdiConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Source] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.mediaconnect.model.Source.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.mediaconnect.model.Source.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        public fun sourceFailoverConfig(block: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.Builder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig] inside the given [block]
         */
        public fun sourceMonitoringConfig(block: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig.Builder.() -> kotlin.Unit) {
            this.sourceMonitoringConfig = aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
