// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.waiters

import aws.sdk.kotlin.services.mediaconnect.MediaConnectClient
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a flow is active
 */
public suspend fun MediaConnectClient.waitUntilFlowActive(request: DescribeFlowRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeFlowResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "STARTING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "UPDATING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "STANDBY"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is active
 */
public suspend fun MediaConnectClient.waitUntilFlowActive(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowActive(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Wait until a flow is deleted
 */
public suspend fun MediaConnectClient.waitUntilFlowDeleted(request: DescribeFlowRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeFlowResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "NotFoundException"),
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "DELETING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is deleted
 */
public suspend fun MediaConnectClient.waitUntilFlowDeleted(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowDeleted(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Wait until a flow is in standby mode
 */
public suspend fun MediaConnectClient.waitUntilFlowStandby(request: DescribeFlowRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeFlowResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeFlowRequest, DescribeFlowResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "STANDBY"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "STOPPING"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InternalServerErrorException"),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ServiceUnavailableException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val flow = it.flow
            val status = flow?.status?.value
            status == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFlow(request) }
}

/**
 * Wait until a flow is in standby mode
 */
public suspend fun MediaConnectClient.waitUntilFlowStandby(block: DescribeFlowRequest.Builder.() -> Unit): Outcome<DescribeFlowResponse> =
    waitUntilFlowStandby(DescribeFlowRequest.Builder().apply(block).build())
