// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance
import aws.sdk.kotlin.services.mediaconnect.model.AddMediaStreamRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig
import aws.sdk.kotlin.services.mediaconnect.model.FlowSize
import aws.sdk.kotlin.services.mediaconnect.model.GrantEntitlementRequest
import aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig
import aws.sdk.kotlin.services.mediaconnect.model.NdiConfig
import aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFlowOperationSerializer: HttpSerializer.NonStreaming<CreateFlowRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFlowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/v1/flows"
        }

        val payload = serializeCreateFlowOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFlowOperationBody(context: ExecutionContext, input: CreateFlowRequest): ByteArray {
    val serializer = JsonSerializer()
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZone"))
    val ENTITLEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entitlements"))
    val FLOWSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("flowSize"))
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val MEDIASTREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mediaStreams"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NDICONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ndiConfig"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputs"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("source"))
    val SOURCEFAILOVERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceFailoverConfig"))
    val SOURCEMONITORINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceMonitoringConfig"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sources"))
    val VPCINTERFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcInterfaces"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(ENTITLEMENTS_DESCRIPTOR)
        field(FLOWSIZE_DESCRIPTOR)
        field(MAINTENANCE_DESCRIPTOR)
        field(MEDIASTREAMS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NDICONFIG_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCEFAILOVERCONFIG_DESCRIPTOR)
        field(SOURCEMONITORINGCONFIG_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
        field(VPCINTERFACES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.availabilityZone?.let { field(AVAILABILITYZONE_DESCRIPTOR, it) }
        if (input.entitlements != null) {
            listField(ENTITLEMENTS_DESCRIPTOR) {
                for (el0 in input.entitlements) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeGrantEntitlementRequestDocument))
                }
            }
        }
        input.flowSize?.let { field(FLOWSIZE_DESCRIPTOR, it.value) }
        input.maintenance?.let { field(MAINTENANCE_DESCRIPTOR, it, ::serializeAddMaintenanceDocument) }
        if (input.mediaStreams != null) {
            listField(MEDIASTREAMS_DESCRIPTOR) {
                for (el0 in input.mediaStreams) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAddMediaStreamRequestDocument))
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.ndiConfig?.let { field(NDICONFIG_DESCRIPTOR, it, ::serializeNdiConfigDocument) }
        if (input.outputs != null) {
            listField(OUTPUTS_DESCRIPTOR) {
                for (el0 in input.outputs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAddOutputRequestDocument))
                }
            }
        }
        input.source?.let { field(SOURCE_DESCRIPTOR, it, ::serializeSetSourceRequestDocument) }
        input.sourceFailoverConfig?.let { field(SOURCEFAILOVERCONFIG_DESCRIPTOR, it, ::serializeFailoverConfigDocument) }
        input.sourceMonitoringConfig?.let { field(SOURCEMONITORINGCONFIG_DESCRIPTOR, it, ::serializeMonitoringConfigDocument) }
        if (input.sources != null) {
            listField(SOURCES_DESCRIPTOR) {
                for (el0 in input.sources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSetSourceRequestDocument))
                }
            }
        }
        if (input.vpcInterfaces != null) {
            listField(VPCINTERFACES_DESCRIPTOR) {
                for (el0 in input.vpcInterfaces) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeVpcInterfaceRequestDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
