// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.AddFlowSourcesResponse
import aws.sdk.kotlin.services.mediaconnect.model.MediaConnectException
import aws.sdk.kotlin.services.mediaconnect.model.Source
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AddFlowSourcesOperationDeserializer: HttpDeserializer.NonStreaming<AddFlowSourcesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddFlowSourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddFlowSourcesError(context, call, payload)
        }
        val builder = AddFlowSourcesResponse.Builder()

        if (payload != null) {
            deserializeAddFlowSourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddFlowSourcesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MediaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddFlowSourcesOperationBody(builder: AddFlowSourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLOWARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowArn"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLOWARN_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLOWARN_DESCRIPTOR.index -> builder.flowArn = deserializeString()
                SOURCES_DESCRIPTOR.index -> builder.sources =
                    deserializer.deserializeList(SOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<Source>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
