// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.paginators

import aws.sdk.kotlin.services.mediaconnect.MediaConnectClient
import aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListBridgesResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListEntitlementsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListEntitlementsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListFlowsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListFlowsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewayInstancesRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewayInstancesResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewaysRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewaysResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListOfferingsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListOfferingsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListReservationsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListReservationsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListedBridge
import aws.sdk.kotlin.services.mediaconnect.model.ListedEntitlement
import aws.sdk.kotlin.services.mediaconnect.model.ListedFlow
import aws.sdk.kotlin.services.mediaconnect.model.ListedGateway
import aws.sdk.kotlin.services.mediaconnect.model.ListedGatewayInstance
import aws.sdk.kotlin.services.mediaconnect.model.Offering
import aws.sdk.kotlin.services.mediaconnect.model.Reservation
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBridgesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBridgesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBridgesResponse]
 */
public fun MediaConnectClient.listBridgesPaginated(initialRequest: ListBridgesRequest = ListBridgesRequest { }): Flow<ListBridgesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBridgesPaginated.listBridges(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBridgesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBridgesResponse]
 */
public fun MediaConnectClient.listBridgesPaginated(block: ListBridgesRequest.Builder.() -> Unit): Flow<ListBridgesResponse> =
    listBridgesPaginated(ListBridgesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBridgesPaginated]
 * to access the nested member [ListedBridge]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedBridge]
 */
@JvmName("listBridgesResponseListedBridge")
public fun Flow<ListBridgesResponse>.bridges(): Flow<ListedBridge> =
    transform() { response ->
        response.bridges?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEntitlementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntitlementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitlementsResponse]
 */
public fun MediaConnectClient.listEntitlementsPaginated(initialRequest: ListEntitlementsRequest = ListEntitlementsRequest { }): Flow<ListEntitlementsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntitlementsPaginated.listEntitlements(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEntitlementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitlementsResponse]
 */
public fun MediaConnectClient.listEntitlementsPaginated(block: ListEntitlementsRequest.Builder.() -> Unit): Flow<ListEntitlementsResponse> =
    listEntitlementsPaginated(ListEntitlementsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEntitlementsPaginated]
 * to access the nested member [ListedEntitlement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedEntitlement]
 */
@JvmName("listEntitlementsResponseListedEntitlement")
public fun Flow<ListEntitlementsResponse>.entitlements(): Flow<ListedEntitlement> =
    transform() { response ->
        response.entitlements?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFlowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowsResponse]
 */
public fun MediaConnectClient.listFlowsPaginated(initialRequest: ListFlowsRequest = ListFlowsRequest { }): Flow<ListFlowsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFlowsPaginated.listFlows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowsResponse]
 */
public fun MediaConnectClient.listFlowsPaginated(block: ListFlowsRequest.Builder.() -> Unit): Flow<ListFlowsResponse> =
    listFlowsPaginated(ListFlowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFlowsPaginated]
 * to access the nested member [ListedFlow]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedFlow]
 */
@JvmName("listFlowsResponseListedFlow")
public fun Flow<ListFlowsResponse>.flows(): Flow<ListedFlow> =
    transform() { response ->
        response.flows?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGatewayInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGatewayInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewayInstancesResponse]
 */
public fun MediaConnectClient.listGatewayInstancesPaginated(initialRequest: ListGatewayInstancesRequest = ListGatewayInstancesRequest { }): Flow<ListGatewayInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGatewayInstancesPaginated.listGatewayInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGatewayInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewayInstancesResponse]
 */
public fun MediaConnectClient.listGatewayInstancesPaginated(block: ListGatewayInstancesRequest.Builder.() -> Unit): Flow<ListGatewayInstancesResponse> =
    listGatewayInstancesPaginated(ListGatewayInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGatewayInstancesPaginated]
 * to access the nested member [ListedGatewayInstance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedGatewayInstance]
 */
@JvmName("listGatewayInstancesResponseListedGatewayInstance")
public fun Flow<ListGatewayInstancesResponse>.instances(): Flow<ListedGatewayInstance> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGatewaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun MediaConnectClient.listGatewaysPaginated(initialRequest: ListGatewaysRequest = ListGatewaysRequest { }): Flow<ListGatewaysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGatewaysPaginated.listGateways(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun MediaConnectClient.listGatewaysPaginated(block: ListGatewaysRequest.Builder.() -> Unit): Flow<ListGatewaysResponse> =
    listGatewaysPaginated(ListGatewaysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGatewaysPaginated]
 * to access the nested member [ListedGateway]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedGateway]
 */
@JvmName("listGatewaysResponseListedGateway")
public fun Flow<ListGatewaysResponse>.gateways(): Flow<ListedGateway> =
    transform() { response ->
        response.gateways?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun MediaConnectClient.listOfferingsPaginated(initialRequest: ListOfferingsRequest = ListOfferingsRequest { }): Flow<ListOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOfferingsPaginated.listOfferings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun MediaConnectClient.listOfferingsPaginated(block: ListOfferingsRequest.Builder.() -> Unit): Flow<ListOfferingsResponse> =
    listOfferingsPaginated(ListOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOfferingsPaginated]
 * to access the nested member [Offering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Offering]
 */
@JvmName("listOfferingsResponseOffering")
public fun Flow<ListOfferingsResponse>.offerings(): Flow<Offering> =
    transform() { response ->
        response.offerings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReservationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReservationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReservationsResponse]
 */
public fun MediaConnectClient.listReservationsPaginated(initialRequest: ListReservationsRequest = ListReservationsRequest { }): Flow<ListReservationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReservationsPaginated.listReservations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReservationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReservationsResponse]
 */
public fun MediaConnectClient.listReservationsPaginated(block: ListReservationsRequest.Builder.() -> Unit): Flow<ListReservationsResponse> =
    listReservationsPaginated(ListReservationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReservationsPaginated]
 * to access the nested member [Reservation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Reservation]
 */
@JvmName("listReservationsResponseReservation")
public fun Flow<ListReservationsResponse>.reservations(): Flow<Reservation> =
    transform() { response ->
        response.reservations?.forEach {
            emit(it)
        }
    }
