// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of the VPC interfaces that you want to add to the flow.
 */
public class VpcInterfaceRequest private constructor(builder: Builder) {
    /**
     * The name for the VPC interface. This name must be unique within the flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of network interface.
     */
    public val networkInterfaceType: aws.sdk.kotlin.services.mediaconnect.model.NetworkInterfaceType? = builder.networkInterfaceType
    /**
     * The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted service.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A virtual firewall to control inbound and outbound traffic.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When you create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block. The subnets that you use across all VPC interfaces on the flow must be in the same Availability Zone as the flow.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcInterfaceRequest(")
        append("name=$name,")
        append("networkInterfaceType=$networkInterfaceType,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcInterfaceRequest

        if (name != other.name) return false
        if (networkInterfaceType != other.networkInterfaceType) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the VPC interface. This name must be unique within the flow.
         */
        public var name: kotlin.String? = null
        /**
         * The type of network interface.
         */
        public var networkInterfaceType: aws.sdk.kotlin.services.mediaconnect.model.NetworkInterfaceType? = null
        /**
         * The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted service.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A virtual firewall to control inbound and outbound traffic.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When you create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block. The subnets that you use across all VPC interfaces on the flow must be in the same Availability Zone as the flow.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest) : this() {
            this.name = x.name
            this.networkInterfaceType = x.networkInterfaceType
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceRequest = VpcInterfaceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
