// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for source failover.
 */
public class UpdateFailoverConfig private constructor(builder: Builder) {
    /**
     * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
     */
    public val failoverMode: aws.sdk.kotlin.services.mediaconnect.model.FailoverMode? = builder.failoverMode
    /**
     * Recovery window time to look for dash-7 packets.
     */
    public val recoveryWindow: kotlin.Int? = builder.recoveryWindow
    /**
     * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
     */
    public val sourcePriority: aws.sdk.kotlin.services.mediaconnect.model.SourcePriority? = builder.sourcePriority
    /**
     * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
     */
    public val state: aws.sdk.kotlin.services.mediaconnect.model.State? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFailoverConfig(")
        append("failoverMode=$failoverMode,")
        append("recoveryWindow=$recoveryWindow,")
        append("sourcePriority=$sourcePriority,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failoverMode?.hashCode() ?: 0
        result = 31 * result + (recoveryWindow ?: 0)
        result = 31 * result + (sourcePriority?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFailoverConfig

        if (failoverMode != other.failoverMode) return false
        if (recoveryWindow != other.recoveryWindow) return false
        if (sourcePriority != other.sourcePriority) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         */
        public var failoverMode: aws.sdk.kotlin.services.mediaconnect.model.FailoverMode? = null
        /**
         * Recovery window time to look for dash-7 packets.
         */
        public var recoveryWindow: kotlin.Int? = null
        /**
         * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
         */
        public var sourcePriority: aws.sdk.kotlin.services.mediaconnect.model.SourcePriority? = null
        /**
         * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
         */
        public var state: aws.sdk.kotlin.services.mediaconnect.model.State? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig) : this() {
            this.failoverMode = x.failoverMode
            this.recoveryWindow = x.recoveryWindow
            this.sourcePriority = x.sourcePriority
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig = UpdateFailoverConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.SourcePriority] inside the given [block]
         */
        public fun sourcePriority(block: aws.sdk.kotlin.services.mediaconnect.model.SourcePriority.Builder.() -> kotlin.Unit) {
            this.sourcePriority = aws.sdk.kotlin.services.mediaconnect.model.SourcePriority.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
