// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the encryption of the flow.
 */
public class UpdateEncryption private constructor(builder: Builder) {
    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     */
    public val algorithm: aws.sdk.kotlin.services.mediaconnect.model.Algorithm? = builder.algorithm
    /**
     * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
     */
    public val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    public val deviceId: kotlin.String? = builder.deviceId
    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    public val keyType: aws.sdk.kotlin.services.mediaconnect.model.KeyType? = builder.keyType
    /**
     * The Amazon Web Services Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    public val region: kotlin.String? = builder.region
    /**
     * An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The ARN of the role that you created during setup (when you set up MediaConnect as a trusted entity).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The ARN of the secret that you created in Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEncryption(")
        append("algorithm=$algorithm,")
        append("constantInitializationVector=$constantInitializationVector,")
        append("deviceId=$deviceId,")
        append("keyType=$keyType,")
        append("region=$region,")
        append("resourceId=$resourceId,")
        append("roleArn=$roleArn,")
        append("secretArn=$secretArn,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (constantInitializationVector?.hashCode() ?: 0)
        result = 31 * result + (deviceId?.hashCode() ?: 0)
        result = 31 * result + (keyType?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEncryption

        if (algorithm != other.algorithm) return false
        if (constantInitializationVector != other.constantInitializationVector) return false
        if (deviceId != other.deviceId) return false
        if (keyType != other.keyType) return false
        if (region != other.region) return false
        if (resourceId != other.resourceId) return false
        if (roleArn != other.roleArn) return false
        if (secretArn != other.secretArn) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         */
        public var algorithm: aws.sdk.kotlin.services.mediaconnect.model.Algorithm? = null
        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
         */
        public var constantInitializationVector: kotlin.String? = null
        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        public var keyType: aws.sdk.kotlin.services.mediaconnect.model.KeyType? = null
        /**
         * The Amazon Web Services Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        public var region: kotlin.String? = null
        /**
         * An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The ARN of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The ARN of the secret that you created in Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption) : this() {
            this.algorithm = x.algorithm
            this.constantInitializationVector = x.constantInitializationVector
            this.deviceId = x.deviceId
            this.keyType = x.keyType
            this.region = x.region
            this.resourceId = x.resourceId
            this.roleArn = x.roleArn
            this.secretArn = x.secretArn
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption = UpdateEncryption(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
