// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The metadata of a single transport stream program.
 */
public class TransportStreamProgram private constructor(builder: Builder) {
    /**
     * The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
     */
    public val pcrPid: kotlin.Int? = builder.pcrPid
    /**
     * The program name as it is reported in the Program Association Table.
     */
    public val programName: kotlin.String? = builder.programName
    /**
     * The program number as it is reported in the Program Association Table.
     */
    public val programNumber: kotlin.Int? = builder.programNumber
    /**
     * The program Packet ID (PID) as it is reported in the Program Association Table.
     */
    public val programPid: kotlin.Int? = builder.programPid
    /**
     * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
     */
    public val streams: List<TransportStream>? = builder.streams

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.TransportStreamProgram = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransportStreamProgram(")
        append("pcrPid=$pcrPid,")
        append("programName=$programName,")
        append("programNumber=$programNumber,")
        append("programPid=$programPid,")
        append("streams=$streams")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pcrPid ?: 0
        result = 31 * result + (programName?.hashCode() ?: 0)
        result = 31 * result + (programNumber ?: 0)
        result = 31 * result + (programPid ?: 0)
        result = 31 * result + (streams?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransportStreamProgram

        if (pcrPid != other.pcrPid) return false
        if (programName != other.programName) return false
        if (programNumber != other.programNumber) return false
        if (programPid != other.programPid) return false
        if (streams != other.streams) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.TransportStreamProgram = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
         */
        public var pcrPid: kotlin.Int? = null
        /**
         * The program name as it is reported in the Program Association Table.
         */
        public var programName: kotlin.String? = null
        /**
         * The program number as it is reported in the Program Association Table.
         */
        public var programNumber: kotlin.Int? = null
        /**
         * The program Packet ID (PID) as it is reported in the Program Association Table.
         */
        public var programPid: kotlin.Int? = null
        /**
         * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
         */
        public var streams: List<TransportStream>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.TransportStreamProgram) : this() {
            this.pcrPid = x.pcrPid
            this.programName = x.programName
            this.programNumber = x.programNumber
            this.programPid = x.programPid
            this.streams = x.streams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.TransportStreamProgram = TransportStreamProgram(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
