// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for the source of the flow.
 */
public class Source private constructor(builder: Builder) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public val dataTransferSubscriberFeePercent: kotlin.Int? = builder.dataTransferSubscriberFeePercent
    /**
     * The type of encryption that is used on the content ingested from this source.
     */
    public val decryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.decryption
    /**
     * A description for the source. This value is not used or seen outside of the current MediaConnect account.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the entitlement that allows you to subscribe to content that comes from another Amazon Web Services account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
     */
    public val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     */
    public val gatewayBridgeSource: aws.sdk.kotlin.services.mediaconnect.model.GatewayBridgeSource? = builder.gatewayBridgeSource
    /**
     * The IP address that the flow will be listening on for incoming content.
     */
    public val ingestIp: kotlin.String? = builder.ingestIp
    /**
     * The port that the flow will be listening on for incoming content.
     */
    public val ingestPort: kotlin.Int? = builder.ingestPort
    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     */
    public val mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = builder.mediaStreamSourceConfigurations
    /**
     * The name of the source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The IP address of the device that is currently sending content to this source.
     *
     * + For sources that use protocols where you specify the origin (such as SRT Caller), this value matches the configured origin address.
     * + For sources that use listener protocols (such as SRT Listener or RTP), this value shows the address of the connected sender.
     * + Peer IP addresses aren't available for entitlements and CDI/ST2110 sources.
     * + The peer IP address might not be visible for flows that haven't been started yet, or flows that were started before May 2025. In these cases, restart your flow to see the peer IP address.
     */
    public val peerIpAddress: kotlin.String? = builder.peerIpAddress
    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    public val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * The ARN of the source.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * Attributes related to the transport stream that are used in the source.
     */
    public val transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = builder.transport
    /**
     * The name of the VPC interface that is used for this source.
     */
    public val vpcInterfaceName: kotlin.String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public val whitelistCidr: kotlin.String? = builder.whitelistCidr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Source = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Source(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("gatewayBridgeSource=$gatewayBridgeSource,")
        append("ingestIp=$ingestIp,")
        append("ingestPort=$ingestPort,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("name=$name,")
        append("peerIpAddress=$peerIpAddress,")
        append("senderControlPort=$senderControlPort,")
        append("senderIpAddress=$senderIpAddress,")
        append("sourceArn=$sourceArn,")
        append("transport=$transport,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (decryption?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayBridgeSource?.hashCode() ?: 0)
        result = 31 * result + (ingestIp?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (peerIpAddress?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Source

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (gatewayBridgeSource != other.gatewayBridgeSource) return false
        if (ingestIp != other.ingestIp) return false
        if (ingestPort != other.ingestPort) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (name != other.name) return false
        if (peerIpAddress != other.peerIpAddress) return false
        if (senderControlPort != other.senderControlPort) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (sourceArn != other.sourceArn) return false
        if (transport != other.transport) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Source = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        public var dataTransferSubscriberFeePercent: kotlin.Int? = null
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        public var decryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * A description for the source. This value is not used or seen outside of the current MediaConnect account.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another Amazon Web Services account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
         */
        public var entitlementArn: kotlin.String? = null
        /**
         * The source configuration for cloud flows receiving a stream from a bridge.
         */
        public var gatewayBridgeSource: aws.sdk.kotlin.services.mediaconnect.model.GatewayBridgeSource? = null
        /**
         * The IP address that the flow will be listening on for incoming content.
         */
        public var ingestIp: kotlin.String? = null
        /**
         * The port that the flow will be listening on for incoming content.
         */
        public var ingestPort: kotlin.Int? = null
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        public var mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = null
        /**
         * The name of the source.
         */
        public var name: kotlin.String? = null
        /**
         * The IP address of the device that is currently sending content to this source.
         *
         * + For sources that use protocols where you specify the origin (such as SRT Caller), this value matches the configured origin address.
         * + For sources that use listener protocols (such as SRT Listener or RTP), this value shows the address of the connected sender.
         * + Peer IP addresses aren't available for entitlements and CDI/ST2110 sources.
         * + The peer IP address might not be visible for flows that haven't been started yet, or flows that were started before May 2025. In these cases, restart your flow to see the peer IP address.
         */
        public var peerIpAddress: kotlin.String? = null
        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         */
        public var senderControlPort: kotlin.Int? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        public var senderIpAddress: kotlin.String? = null
        /**
         * The ARN of the source.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * Attributes related to the transport stream that are used in the source.
         */
        public var transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = null
        /**
         * The name of the VPC interface that is used for this source.
         */
        public var vpcInterfaceName: kotlin.String? = null
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        public var whitelistCidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Source) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.gatewayBridgeSource = x.gatewayBridgeSource
            this.ingestIp = x.ingestIp
            this.ingestPort = x.ingestPort
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.name = x.name
            this.peerIpAddress = x.peerIpAddress
            this.senderControlPort = x.senderControlPort
            this.senderIpAddress = x.senderIpAddress
            this.sourceArn = x.sourceArn
            this.transport = x.transport
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Source = Source(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        public fun decryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.decryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.GatewayBridgeSource] inside the given [block]
         */
        public fun gatewayBridgeSource(block: aws.sdk.kotlin.services.mediaconnect.model.GatewayBridgeSource.Builder.() -> kotlin.Unit) {
            this.gatewayBridgeSource = aws.sdk.kotlin.services.mediaconnect.model.GatewayBridgeSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        public fun transport(block: aws.sdk.kotlin.services.mediaconnect.model.Transport.Builder.() -> kotlin.Unit) {
            this.transport = aws.sdk.kotlin.services.mediaconnect.model.Transport.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
