// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration settings for individual NDI discovery servers. A maximum of 3 servers is allowed.
 */
public class NdiDiscoveryServerConfig private constructor(builder: Builder) {
    /**
     * The unique network address of the NDI discovery server.
     */
    public val discoveryServerAddress: kotlin.String? = builder.discoveryServerAddress
    /**
     * The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
     */
    public val discoveryServerPort: kotlin.Int? = builder.discoveryServerPort
    /**
     * The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
     */
    public val vpcInterfaceAdapter: kotlin.String? = builder.vpcInterfaceAdapter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.NdiDiscoveryServerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NdiDiscoveryServerConfig(")
        append("discoveryServerAddress=$discoveryServerAddress,")
        append("discoveryServerPort=$discoveryServerPort,")
        append("vpcInterfaceAdapter=$vpcInterfaceAdapter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = discoveryServerAddress?.hashCode() ?: 0
        result = 31 * result + (discoveryServerPort ?: 0)
        result = 31 * result + (vpcInterfaceAdapter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NdiDiscoveryServerConfig

        if (discoveryServerAddress != other.discoveryServerAddress) return false
        if (discoveryServerPort != other.discoveryServerPort) return false
        if (vpcInterfaceAdapter != other.vpcInterfaceAdapter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.NdiDiscoveryServerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique network address of the NDI discovery server.
         */
        public var discoveryServerAddress: kotlin.String? = null
        /**
         * The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
         */
        public var discoveryServerPort: kotlin.Int? = null
        /**
         * The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
         */
        public var vpcInterfaceAdapter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.NdiDiscoveryServerConfig) : this() {
            this.discoveryServerAddress = x.discoveryServerAddress
            this.discoveryServerPort = x.discoveryServerPort
            this.vpcInterfaceAdapter = x.vpcInterfaceAdapter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.NdiDiscoveryServerConfig = NdiDiscoveryServerConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
