// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
 */
public class NdiConfig private constructor(builder: Builder) {
    /**
     * A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect generates a unique 12-character ID as the prefix.
     */
    public val machineName: kotlin.String? = builder.machineName
    /**
     * A list of up to three NDI discovery server configurations. While not required by the API, this configuration is necessary for NDI functionality to work properly.
     */
    public val ndiDiscoveryServers: List<NdiDiscoveryServerConfig>? = builder.ndiDiscoveryServers
    /**
     * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default is DISABLED.
     */
    public val ndiState: aws.sdk.kotlin.services.mediaconnect.model.NdiState? = builder.ndiState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.NdiConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NdiConfig(")
        append("machineName=$machineName,")
        append("ndiDiscoveryServers=$ndiDiscoveryServers,")
        append("ndiState=$ndiState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = machineName?.hashCode() ?: 0
        result = 31 * result + (ndiDiscoveryServers?.hashCode() ?: 0)
        result = 31 * result + (ndiState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NdiConfig

        if (machineName != other.machineName) return false
        if (ndiDiscoveryServers != other.ndiDiscoveryServers) return false
        if (ndiState != other.ndiState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.NdiConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect generates a unique 12-character ID as the prefix.
         */
        public var machineName: kotlin.String? = null
        /**
         * A list of up to three NDI discovery server configurations. While not required by the API, this configuration is necessary for NDI functionality to work properly.
         */
        public var ndiDiscoveryServers: List<NdiDiscoveryServerConfig>? = null
        /**
         * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default is DISABLED.
         */
        public var ndiState: aws.sdk.kotlin.services.mediaconnect.model.NdiState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig) : this() {
            this.machineName = x.machineName
            this.ndiDiscoveryServers = x.ndiDiscoveryServers
            this.ndiState = x.ndiState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.NdiConfig = NdiConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
