// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListBridgesRequest private constructor(builder: Builder) {
    /**
     * Filter the list results to display only the bridges associated with the selected ARN.
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The maximum number of results to return per API request.
     *
     * For example, you submit a `ListBridges` request with `MaxResults` set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a `NextToken` value that you can use to fetch the next batch of results.)
     *
     * The service might return fewer results than the `MaxResults` value. If `MaxResults` is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token that identifies the batch of results that you want to see.
     *
     * For example, you submit a `ListBridges` request with `MaxResults` set at 5. The service returns the first batch of results (up to 5) and a `NextToken` value. To see the next batch of results, you can submit the `ListBridges` request a second time and specify the `NextToken` value.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBridgesRequest(")
        append("filterArn=$filterArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBridgesRequest

        if (filterArn != other.filterArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Filter the list results to display only the bridges associated with the selected ARN.
         */
        public var filterArn: kotlin.String? = null
        /**
         * The maximum number of results to return per API request.
         *
         * For example, you submit a `ListBridges` request with `MaxResults` set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a `NextToken` value that you can use to fetch the next batch of results.)
         *
         * The service might return fewer results than the `MaxResults` value. If `MaxResults` is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token that identifies the batch of results that you want to see.
         *
         * For example, you submit a `ListBridges` request with `MaxResults` set at 5. The service returns the first batch of results (up to 5) and a `NextToken` value. To see the next batch of results, you can submit the `ListBridges` request a second time and specify the `NextToken` value.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest) : this() {
            this.filterArn = x.filterArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest = ListBridgesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
