// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFlowRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current Amazon Web Services Region.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The entitlements that you want to grant on a flow.
     */
    public val entitlements: List<GrantEntitlementRequest>? = builder.entitlements
    /**
     * Determines the processing capacity and feature set of the flow. Set this optional parameter to `LARGE` if you want to enable NDI outputs on the flow.
     */
    public val flowSize: aws.sdk.kotlin.services.mediaconnect.model.FlowSize? = builder.flowSize
    /**
     * The maintenance settings you want to use for the flow.
     */
    public val maintenance: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance? = builder.maintenance
    /**
     * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
     */
    public val mediaStreams: List<AddMediaStreamRequest>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     */
    public val ndiConfig: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig? = builder.ndiConfig
    /**
     * The outputs that you want to add to this flow.
     */
    public val outputs: List<AddOutputRequest>? = builder.outputs
    /**
     * The settings for the source that you want to use for the new flow.
     */
    public val source: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest? = builder.source
    /**
     * The settings for source failover.
     */
    public val sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = builder.sourceFailoverConfig
    /**
     * The settings for source monitoring.
     */
    public val sourceMonitoringConfig: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig? = builder.sourceMonitoringConfig
    /**
     * The sources that are assigned to the flow.
     */
    public val sources: List<SetSourceRequest>? = builder.sources
    /**
     * The VPC interfaces you want on the flow.
     */
    public val vpcInterfaces: List<VpcInterfaceRequest>? = builder.vpcInterfaces

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowRequest(")
        append("availabilityZone=$availabilityZone,")
        append("entitlements=$entitlements,")
        append("flowSize=$flowSize,")
        append("maintenance=$maintenance,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("ndiConfig=$ndiConfig,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sourceMonitoringConfig=$sourceMonitoringConfig,")
        append("sources=$sources,")
        append("vpcInterfaces=$vpcInterfaces")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (flowSize?.hashCode() ?: 0)
        result = 31 * result + (maintenance?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ndiConfig?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceMonitoringConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFlowRequest

        if (availabilityZone != other.availabilityZone) return false
        if (entitlements != other.entitlements) return false
        if (flowSize != other.flowSize) return false
        if (maintenance != other.maintenance) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (ndiConfig != other.ndiConfig) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sourceMonitoringConfig != other.sourceMonitoringConfig) return false
        if (sources != other.sources) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current Amazon Web Services Region.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The entitlements that you want to grant on a flow.
         */
        public var entitlements: List<GrantEntitlementRequest>? = null
        /**
         * Determines the processing capacity and feature set of the flow. Set this optional parameter to `LARGE` if you want to enable NDI outputs on the flow.
         */
        public var flowSize: aws.sdk.kotlin.services.mediaconnect.model.FlowSize? = null
        /**
         * The maintenance settings you want to use for the flow.
         */
        public var maintenance: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance? = null
        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
         */
        public var mediaStreams: List<AddMediaStreamRequest>? = null
        /**
         * The name of the flow.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         */
        public var ndiConfig: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig? = null
        /**
         * The outputs that you want to add to this flow.
         */
        public var outputs: List<AddOutputRequest>? = null
        /**
         * The settings for the source that you want to use for the new flow.
         */
        public var source: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest? = null
        /**
         * The settings for source failover.
         */
        public var sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = null
        /**
         * The settings for source monitoring.
         */
        public var sourceMonitoringConfig: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig? = null
        /**
         * The sources that are assigned to the flow.
         */
        public var sources: List<SetSourceRequest>? = null
        /**
         * The VPC interfaces you want on the flow.
         */
        public var vpcInterfaces: List<VpcInterfaceRequest>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.entitlements = x.entitlements
            this.flowSize = x.flowSize
            this.maintenance = x.maintenance
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.ndiConfig = x.ndiConfig
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sourceMonitoringConfig = x.sourceMonitoringConfig
            this.sources = x.sources
            this.vpcInterfaces = x.vpcInterfaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest = CreateFlowRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance] inside the given [block]
         */
        public fun maintenance(block: aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance.Builder.() -> kotlin.Unit) {
            this.maintenance = aws.sdk.kotlin.services.mediaconnect.model.AddMaintenance.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.NdiConfig] inside the given [block]
         */
        public fun ndiConfig(block: aws.sdk.kotlin.services.mediaconnect.model.NdiConfig.Builder.() -> kotlin.Unit) {
            this.ndiConfig = aws.sdk.kotlin.services.mediaconnect.model.NdiConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        public fun sourceFailoverConfig(block: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.Builder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig] inside the given [block]
         */
        public fun sourceMonitoringConfig(block: aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig.Builder.() -> kotlin.Unit) {
            this.sourceMonitoringConfig = aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
