// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A Bridge is the connection between your data center's Instances and the Amazon Web Services cloud. A bridge can be used to send video from the Amazon Web Services cloud to your data center or from your data center to the Amazon Web Services cloud.
 */
public class Bridge private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of the bridge.
     */
    public val bridgeArn: kotlin.String? = builder.bridgeArn
    /**
     * Messages with details about the bridge.
     */
    public val bridgeMessages: List<MessageDetail>? = builder.bridgeMessages
    /**
     * The state of the bridge.
     */
    public val bridgeState: aws.sdk.kotlin.services.mediaconnect.model.BridgeState? = builder.bridgeState
    /**
     * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
     */
    public val egressGatewayBridge: aws.sdk.kotlin.services.mediaconnect.model.EgressGatewayBridge? = builder.egressGatewayBridge
    /**
     * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
     */
    public val ingressGatewayBridge: aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge? = builder.ingressGatewayBridge
    /**
     * The name of the bridge.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The outputs on this bridge.
     */
    public val outputs: List<BridgeOutput>? = builder.outputs
    /**
     * The placement Amazon Resource Number (ARN) of the bridge.
     */
    public val placementArn: kotlin.String? = builder.placementArn
    /**
     * The settings for source failover.
     */
    public val sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = builder.sourceFailoverConfig
    /**
     * The sources on this bridge.
     */
    public val sources: List<BridgeSource>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Bridge = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Bridge(")
        append("bridgeArn=$bridgeArn,")
        append("bridgeMessages=$bridgeMessages,")
        append("bridgeState=$bridgeState,")
        append("egressGatewayBridge=$egressGatewayBridge,")
        append("ingressGatewayBridge=$ingressGatewayBridge,")
        append("name=$name,")
        append("outputs=$outputs,")
        append("placementArn=$placementArn,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sources=$sources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bridgeArn?.hashCode() ?: 0
        result = 31 * result + (bridgeMessages?.hashCode() ?: 0)
        result = 31 * result + (bridgeState?.hashCode() ?: 0)
        result = 31 * result + (egressGatewayBridge?.hashCode() ?: 0)
        result = 31 * result + (ingressGatewayBridge?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (placementArn?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Bridge

        if (bridgeArn != other.bridgeArn) return false
        if (bridgeMessages != other.bridgeMessages) return false
        if (bridgeState != other.bridgeState) return false
        if (egressGatewayBridge != other.egressGatewayBridge) return false
        if (ingressGatewayBridge != other.ingressGatewayBridge) return false
        if (name != other.name) return false
        if (outputs != other.outputs) return false
        if (placementArn != other.placementArn) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Bridge = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Number (ARN) of the bridge.
         */
        public var bridgeArn: kotlin.String? = null
        /**
         * Messages with details about the bridge.
         */
        public var bridgeMessages: List<MessageDetail>? = null
        /**
         * The state of the bridge.
         */
        public var bridgeState: aws.sdk.kotlin.services.mediaconnect.model.BridgeState? = null
        /**
         * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
         */
        public var egressGatewayBridge: aws.sdk.kotlin.services.mediaconnect.model.EgressGatewayBridge? = null
        /**
         * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
         */
        public var ingressGatewayBridge: aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge? = null
        /**
         * The name of the bridge.
         */
        public var name: kotlin.String? = null
        /**
         * The outputs on this bridge.
         */
        public var outputs: List<BridgeOutput>? = null
        /**
         * The placement Amazon Resource Number (ARN) of the bridge.
         */
        public var placementArn: kotlin.String? = null
        /**
         * The settings for source failover.
         */
        public var sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = null
        /**
         * The sources on this bridge.
         */
        public var sources: List<BridgeSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Bridge) : this() {
            this.bridgeArn = x.bridgeArn
            this.bridgeMessages = x.bridgeMessages
            this.bridgeState = x.bridgeState
            this.egressGatewayBridge = x.egressGatewayBridge
            this.ingressGatewayBridge = x.ingressGatewayBridge
            this.name = x.name
            this.outputs = x.outputs
            this.placementArn = x.placementArn
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Bridge = Bridge(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EgressGatewayBridge] inside the given [block]
         */
        public fun egressGatewayBridge(block: aws.sdk.kotlin.services.mediaconnect.model.EgressGatewayBridge.Builder.() -> kotlin.Unit) {
            this.egressGatewayBridge = aws.sdk.kotlin.services.mediaconnect.model.EgressGatewayBridge.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge] inside the given [block]
         */
        public fun ingressGatewayBridge(block: aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge.Builder.() -> kotlin.Unit) {
            this.ingressGatewayBridge = aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        public fun sourceFailoverConfig(block: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.Builder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
