// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediaconnect.auth.DefaultMediaConnectAuthSchemeProvider
import aws.sdk.kotlin.services.mediaconnect.auth.MediaConnectAuthSchemeProvider
import aws.sdk.kotlin.services.mediaconnect.endpoints.DefaultMediaConnectEndpointProvider
import aws.sdk.kotlin.services.mediaconnect.endpoints.MediaConnectEndpointParameters
import aws.sdk.kotlin.services.mediaconnect.endpoints.MediaConnectEndpointProvider
import aws.sdk.kotlin.services.mediaconnect.model.AddBridgeOutputsRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddBridgeOutputsResponse
import aws.sdk.kotlin.services.mediaconnect.model.AddBridgeSourcesRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddBridgeSourcesResponse
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowMediaStreamsRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowMediaStreamsResponse
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowOutputsRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowOutputsResponse
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowSourcesRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowSourcesResponse
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowVpcInterfacesRequest
import aws.sdk.kotlin.services.mediaconnect.model.AddFlowVpcInterfacesResponse
import aws.sdk.kotlin.services.mediaconnect.model.CreateBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.CreateBridgeResponse
import aws.sdk.kotlin.services.mediaconnect.model.CreateFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.CreateFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.CreateGatewayRequest
import aws.sdk.kotlin.services.mediaconnect.model.CreateGatewayResponse
import aws.sdk.kotlin.services.mediaconnect.model.DeleteBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.DeleteBridgeResponse
import aws.sdk.kotlin.services.mediaconnect.model.DeleteFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.DeleteFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.DeleteGatewayRequest
import aws.sdk.kotlin.services.mediaconnect.model.DeleteGatewayResponse
import aws.sdk.kotlin.services.mediaconnect.model.DeregisterGatewayInstanceRequest
import aws.sdk.kotlin.services.mediaconnect.model.DeregisterGatewayInstanceResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeBridgeResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowSourceMetadataRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowSourceMetadataResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeGatewayInstanceRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeGatewayInstanceResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeGatewayRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeGatewayResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeOfferingRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeOfferingResponse
import aws.sdk.kotlin.services.mediaconnect.model.DescribeReservationRequest
import aws.sdk.kotlin.services.mediaconnect.model.DescribeReservationResponse
import aws.sdk.kotlin.services.mediaconnect.model.GrantFlowEntitlementsRequest
import aws.sdk.kotlin.services.mediaconnect.model.GrantFlowEntitlementsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListBridgesRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListBridgesResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListEntitlementsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListEntitlementsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListFlowsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListFlowsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewayInstancesRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewayInstancesResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewaysRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListGatewaysResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListOfferingsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListOfferingsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListReservationsRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListReservationsResponse
import aws.sdk.kotlin.services.mediaconnect.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.PurchaseOfferingRequest
import aws.sdk.kotlin.services.mediaconnect.model.PurchaseOfferingResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveBridgeOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveBridgeOutputResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveBridgeSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveBridgeSourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowMediaStreamRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowMediaStreamResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowOutputResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowSourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest
import aws.sdk.kotlin.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse
import aws.sdk.kotlin.services.mediaconnect.model.RevokeFlowEntitlementRequest
import aws.sdk.kotlin.services.mediaconnect.model.RevokeFlowEntitlementResponse
import aws.sdk.kotlin.services.mediaconnect.model.StartFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.StartFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.StopFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.StopFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.TagResourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.TagResourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeOutputResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeSourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeStateRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeStateResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowEntitlementRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowEntitlementResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowMediaStreamRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowMediaStreamResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceResponse
import aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayInstanceRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayInstanceResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "MediaConnect"
public const val SdkVersion: String = "1.5.38"
public const val ServiceApiVersion: String = "2018-11-14"

/**
 * Welcome to the Elemental MediaConnect API reference.
 *
 * MediaConnect is a service that lets you ingest live video content into the cloud and distribute it to destinations all over the world, both inside and outside the Amazon Web Services cloud. This API reference provides descriptions, syntax, and usage examples for each of the actions and data types that are supported by MediaConnect.
 *
 * Use the following links to get started with the MediaConnect API:
 * + [Actions](https://docs.aws.amazon.com/mediaconnect/latest/api/API_Operations.html): An alphabetical list of all MediaConnect API operations.
 * + [Data types](https://docs.aws.amazon.com/mediaconnect/latest/api/API_Types.html): An alphabetical list of all MediaConnect data types.
 * + [Common parameters](https://docs.aws.amazon.com/mediaconnect/latest/api/CommonParameters.html): Parameters that all operations can use.
 * + [Common errors](https://docs.aws.amazon.com/mediaconnect/latest/api/CommonErrors.html): Client and server errors that all operations can return.
 */
public interface MediaConnectClient : SdkClient {
    /**
     * MediaConnectClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaConnectClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaConnect",
                "MEDIACONNECT",
                "mediaconnect",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaConnectClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaConnectClient = DefaultMediaConnectClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaConnectEndpointProvider = builder.endpointProvider ?: DefaultMediaConnectEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaConnectAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaConnectAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaConnect"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaConnectEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaConnectAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds outputs to an existing bridge.
     */
    public suspend fun addBridgeOutputs(input: AddBridgeOutputsRequest): AddBridgeOutputsResponse

    /**
     * Adds sources to an existing bridge.
     */
    public suspend fun addBridgeSources(input: AddBridgeSourcesRequest): AddBridgeSourcesResponse

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    public suspend fun addFlowMediaStreams(input: AddFlowMediaStreamsRequest): AddFlowMediaStreamsResponse

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    public suspend fun addFlowOutputs(input: AddFlowOutputsRequest): AddFlowOutputsResponse

    /**
     * Adds sources to a flow.
     */
    public suspend fun addFlowSources(input: AddFlowSourcesRequest): AddFlowSourcesResponse

    /**
     * Adds VPC interfaces to a flow.
     */
    public suspend fun addFlowVpcInterfaces(input: AddFlowVpcInterfacesRequest): AddFlowVpcInterfacesResponse

    /**
     * Creates a new bridge. The request must include one source.
     */
    public suspend fun createBridge(input: CreateBridgeRequest): CreateBridgeResponse

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    public suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse

    /**
     * Creates a new gateway. The request must include at least one network (up to four).
     */
    public suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     */
    public suspend fun deleteBridge(input: DeleteBridgeRequest): DeleteBridgeResponse

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    public suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse

    /**
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     */
    public suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped. If you want to deregister an instance without stopping the bridges, you must use the --force option.
     */
    public suspend fun deregisterGatewayInstance(input: DeregisterGatewayInstanceRequest): DeregisterGatewayInstanceResponse

    /**
     * Displays the details of a bridge.
     */
    public suspend fun describeBridge(input: DescribeBridgeRequest): DescribeBridgeResponse

    /**
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    public suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse

    /**
     * The `DescribeFlowSourceMetadata` API is used to view information about the flow's source transport stream and programs. This API displays status messages about the flow's source as well as details about the program's video, audio, and other data.
     */
    public suspend fun describeFlowSourceMetadata(input: DescribeFlowSourceMetadataRequest): DescribeFlowSourceMetadataResponse

    /**
     * Describes the thumbnail for the flow source.
     */
    public suspend fun describeFlowSourceThumbnail(input: DescribeFlowSourceThumbnailRequest): DescribeFlowSourceThumbnailResponse

    /**
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR blocks, as well as details about the networks.
     */
    public suspend fun describeGateway(input: DescribeGatewayRequest): DescribeGatewayResponse

    /**
     * Displays the details of an instance.
     */
    public suspend fun describeGatewayInstance(input: DescribeGatewayInstanceRequest): DescribeGatewayInstanceResponse

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    public suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    public suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse

    /**
     * Grants entitlements to an existing flow.
     */
    public suspend fun grantFlowEntitlements(input: GrantFlowEntitlementsRequest): GrantFlowEntitlementsResponse

    /**
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name (ARN). This request returns a paginated result.
     */
    public suspend fun listBridges(input: ListBridgesRequest = ListBridgesRequest { }): ListBridgesResponse

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    public suspend fun listEntitlements(input: ListEntitlementsRequest = ListEntitlementsRequest { }): ListEntitlementsResponse

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    public suspend fun listFlows(input: ListFlowsRequest = ListFlowsRequest { }): ListFlowsResponse

    /**
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated result. You can use the filterArn property to display only the instances associated with the selected Gateway Amazon Resource Name (ARN).
     */
    public suspend fun listGatewayInstances(input: ListGatewayInstancesRequest = ListGatewayInstancesRequest { }): ListGatewayInstancesResponse

    /**
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     */
    public suspend fun listGateways(input: ListGatewaysRequest = ListGatewaysRequest { }): ListGatewaysResponse

    /**
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    public suspend fun listOfferings(input: ListOfferingsRequest = ListOfferingsRequest { }): ListOfferingsResponse

    /**
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services Region. This list includes all reservations in all states (such as active and expired).
     */
    public suspend fun listReservations(input: ListReservationsRequest = ListReservationsRequest { }): ListReservationsResponse

    /**
     * List all tags on a MediaConnect resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    public suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Removes an output from a bridge.
     */
    public suspend fun removeBridgeOutput(input: RemoveBridgeOutputRequest): RemoveBridgeOutputResponse

    /**
     * Removes a source from a bridge.
     */
    public suspend fun removeBridgeSource(input: RemoveBridgeSourceRequest): RemoveBridgeSourceResponse

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    public suspend fun removeFlowMediaStream(input: RemoveFlowMediaStreamRequest): RemoveFlowMediaStreamResponse

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    public suspend fun removeFlowOutput(input: RemoveFlowOutputRequest): RemoveFlowOutputResponse

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    public suspend fun removeFlowSource(input: RemoveFlowSourceRequest): RemoveFlowSourceResponse

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    public suspend fun removeFlowVpcInterface(input: RemoveFlowVpcInterfaceRequest): RemoveFlowVpcInterfaceResponse

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    public suspend fun revokeFlowEntitlement(input: RevokeFlowEntitlementRequest): RevokeFlowEntitlementResponse

    /**
     * Starts a flow.
     */
    public suspend fun startFlow(input: StartFlowRequest): StartFlowResponse

    /**
     * Stops a flow.
     */
    public suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the bridge.
     */
    public suspend fun updateBridge(input: UpdateBridgeRequest): UpdateBridgeResponse

    /**
     * Updates an existing bridge output.
     */
    public suspend fun updateBridgeOutput(input: UpdateBridgeOutputRequest): UpdateBridgeOutputResponse

    /**
     * Updates an existing bridge source.
     */
    public suspend fun updateBridgeSource(input: UpdateBridgeSourceRequest): UpdateBridgeSourceResponse

    /**
     * Updates the bridge state.
     */
    public suspend fun updateBridgeState(input: UpdateBridgeStateRequest): UpdateBridgeStateResponse

    /**
     * Updates an existing flow.
     */
    public suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse

    /**
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    public suspend fun updateFlowEntitlement(input: UpdateFlowEntitlementRequest): UpdateFlowEntitlementResponse

    /**
     * Updates an existing media stream.
     */
    public suspend fun updateFlowMediaStream(input: UpdateFlowMediaStreamRequest): UpdateFlowMediaStreamResponse

    /**
     * Updates an existing flow output.
     */
    public suspend fun updateFlowOutput(input: UpdateFlowOutputRequest): UpdateFlowOutputResponse

    /**
     * Updates the source of a flow.
     */
    public suspend fun updateFlowSource(input: UpdateFlowSourceRequest): UpdateFlowSourceResponse

    /**
     * Updates an existing gateway instance.
     */
    public suspend fun updateGatewayInstance(input: UpdateGatewayInstanceRequest): UpdateGatewayInstanceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaConnectClient.withConfig(block: MediaConnectClient.Config.Builder.() -> Unit): MediaConnectClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaConnectClient(newConfig)
}

/**
 * Adds outputs to an existing bridge.
 */
public suspend inline fun MediaConnectClient.addBridgeOutputs(crossinline block: AddBridgeOutputsRequest.Builder.() -> Unit): AddBridgeOutputsResponse = addBridgeOutputs(AddBridgeOutputsRequest.Builder().apply(block).build())

/**
 * Adds sources to an existing bridge.
 */
public suspend inline fun MediaConnectClient.addBridgeSources(crossinline block: AddBridgeSourcesRequest.Builder.() -> Unit): AddBridgeSourcesResponse = addBridgeSources(AddBridgeSourcesRequest.Builder().apply(block).build())

/**
 * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
 */
public suspend inline fun MediaConnectClient.addFlowMediaStreams(crossinline block: AddFlowMediaStreamsRequest.Builder.() -> Unit): AddFlowMediaStreamsResponse = addFlowMediaStreams(AddFlowMediaStreamsRequest.Builder().apply(block).build())

/**
 * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
 */
public suspend inline fun MediaConnectClient.addFlowOutputs(crossinline block: AddFlowOutputsRequest.Builder.() -> Unit): AddFlowOutputsResponse = addFlowOutputs(AddFlowOutputsRequest.Builder().apply(block).build())

/**
 * Adds sources to a flow.
 */
public suspend inline fun MediaConnectClient.addFlowSources(crossinline block: AddFlowSourcesRequest.Builder.() -> Unit): AddFlowSourcesResponse = addFlowSources(AddFlowSourcesRequest.Builder().apply(block).build())

/**
 * Adds VPC interfaces to a flow.
 */
public suspend inline fun MediaConnectClient.addFlowVpcInterfaces(crossinline block: AddFlowVpcInterfacesRequest.Builder.() -> Unit): AddFlowVpcInterfacesResponse = addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.Builder().apply(block).build())

/**
 * Creates a new bridge. The request must include one source.
 */
public suspend inline fun MediaConnectClient.createBridge(crossinline block: CreateBridgeRequest.Builder.() -> Unit): CreateBridgeResponse = createBridge(CreateBridgeRequest.Builder().apply(block).build())

/**
 * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
 */
public suspend inline fun MediaConnectClient.createFlow(crossinline block: CreateFlowRequest.Builder.() -> Unit): CreateFlowResponse = createFlow(CreateFlowRequest.Builder().apply(block).build())

/**
 * Creates a new gateway. The request must include at least one network (up to four).
 */
public suspend inline fun MediaConnectClient.createGateway(crossinline block: CreateGatewayRequest.Builder.() -> Unit): CreateGatewayResponse = createGateway(CreateGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
 */
public suspend inline fun MediaConnectClient.deleteBridge(crossinline block: DeleteBridgeRequest.Builder.() -> Unit): DeleteBridgeResponse = deleteBridge(DeleteBridgeRequest.Builder().apply(block).build())

/**
 * Deletes a flow. Before you can delete a flow, you must stop the flow.
 */
public suspend inline fun MediaConnectClient.deleteFlow(crossinline block: DeleteFlowRequest.Builder.() -> Unit): DeleteFlowResponse = deleteFlow(DeleteFlowRequest.Builder().apply(block).build())

/**
 * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
 */
public suspend inline fun MediaConnectClient.deleteGateway(crossinline block: DeleteGatewayRequest.Builder.() -> Unit): DeleteGatewayResponse = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

/**
 * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped. If you want to deregister an instance without stopping the bridges, you must use the --force option.
 */
public suspend inline fun MediaConnectClient.deregisterGatewayInstance(crossinline block: DeregisterGatewayInstanceRequest.Builder.() -> Unit): DeregisterGatewayInstanceResponse = deregisterGatewayInstance(DeregisterGatewayInstanceRequest.Builder().apply(block).build())

/**
 * Displays the details of a bridge.
 */
public suspend inline fun MediaConnectClient.describeBridge(crossinline block: DescribeBridgeRequest.Builder.() -> Unit): DescribeBridgeResponse = describeBridge(DescribeBridgeRequest.Builder().apply(block).build())

/**
 * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability Zone, as well as details about the source, outputs, and entitlements.
 */
public suspend inline fun MediaConnectClient.describeFlow(crossinline block: DescribeFlowRequest.Builder.() -> Unit): DescribeFlowResponse = describeFlow(DescribeFlowRequest.Builder().apply(block).build())

/**
 * The `DescribeFlowSourceMetadata` API is used to view information about the flow's source transport stream and programs. This API displays status messages about the flow's source as well as details about the program's video, audio, and other data.
 */
public suspend inline fun MediaConnectClient.describeFlowSourceMetadata(crossinline block: DescribeFlowSourceMetadataRequest.Builder.() -> Unit): DescribeFlowSourceMetadataResponse = describeFlowSourceMetadata(DescribeFlowSourceMetadataRequest.Builder().apply(block).build())

/**
 * Describes the thumbnail for the flow source.
 */
public suspend inline fun MediaConnectClient.describeFlowSourceThumbnail(crossinline block: DescribeFlowSourceThumbnailRequest.Builder.() -> Unit): DescribeFlowSourceThumbnailResponse = describeFlowSourceThumbnail(DescribeFlowSourceThumbnailRequest.Builder().apply(block).build())

/**
 * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR blocks, as well as details about the networks.
 */
public suspend inline fun MediaConnectClient.describeGateway(crossinline block: DescribeGatewayRequest.Builder.() -> Unit): DescribeGatewayResponse = describeGateway(DescribeGatewayRequest.Builder().apply(block).build())

/**
 * Displays the details of an instance.
 */
public suspend inline fun MediaConnectClient.describeGatewayInstance(crossinline block: DescribeGatewayInstanceRequest.Builder.() -> Unit): DescribeGatewayInstanceResponse = describeGatewayInstance(DescribeGatewayInstanceRequest.Builder().apply(block).build())

/**
 * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
 */
public suspend inline fun MediaConnectClient.describeOffering(crossinline block: DescribeOfferingRequest.Builder.() -> Unit): DescribeOfferingResponse = describeOffering(DescribeOfferingRequest.Builder().apply(block).build())

/**
 * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
 */
public suspend inline fun MediaConnectClient.describeReservation(crossinline block: DescribeReservationRequest.Builder.() -> Unit): DescribeReservationResponse = describeReservation(DescribeReservationRequest.Builder().apply(block).build())

/**
 * Grants entitlements to an existing flow.
 */
public suspend inline fun MediaConnectClient.grantFlowEntitlements(crossinline block: GrantFlowEntitlementsRequest.Builder.() -> Unit): GrantFlowEntitlementsResponse = grantFlowEntitlements(GrantFlowEntitlementsRequest.Builder().apply(block).build())

/**
 * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name (ARN). This request returns a paginated result.
 */
public suspend inline fun MediaConnectClient.listBridges(crossinline block: ListBridgesRequest.Builder.() -> Unit): ListBridgesResponse = listBridges(ListBridgesRequest.Builder().apply(block).build())

/**
 * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
 */
public suspend inline fun MediaConnectClient.listEntitlements(crossinline block: ListEntitlementsRequest.Builder.() -> Unit): ListEntitlementsResponse = listEntitlements(ListEntitlementsRequest.Builder().apply(block).build())

/**
 * Displays a list of flows that are associated with this account. This request returns a paginated result.
 */
public suspend inline fun MediaConnectClient.listFlows(crossinline block: ListFlowsRequest.Builder.() -> Unit): ListFlowsResponse = listFlows(ListFlowsRequest.Builder().apply(block).build())

/**
 * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated result. You can use the filterArn property to display only the instances associated with the selected Gateway Amazon Resource Name (ARN).
 */
public suspend inline fun MediaConnectClient.listGatewayInstances(crossinline block: ListGatewayInstancesRequest.Builder.() -> Unit): ListGatewayInstancesResponse = listGatewayInstances(ListGatewayInstancesRequest.Builder().apply(block).build())

/**
 * Displays a list of gateways that are associated with this account. This request returns a paginated result.
 */
public suspend inline fun MediaConnectClient.listGateways(crossinline block: ListGatewaysRequest.Builder.() -> Unit): ListGatewaysResponse = listGateways(ListGatewaysRequest.Builder().apply(block).build())

/**
 * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
 */
public suspend inline fun MediaConnectClient.listOfferings(crossinline block: ListOfferingsRequest.Builder.() -> Unit): ListOfferingsResponse = listOfferings(ListOfferingsRequest.Builder().apply(block).build())

/**
 * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services Region. This list includes all reservations in all states (such as active and expired).
 */
public suspend inline fun MediaConnectClient.listReservations(crossinline block: ListReservationsRequest.Builder.() -> Unit): ListReservationsResponse = listReservations(ListReservationsRequest.Builder().apply(block).build())

/**
 * List all tags on a MediaConnect resource.
 */
public suspend inline fun MediaConnectClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
 */
public suspend inline fun MediaConnectClient.purchaseOffering(crossinline block: PurchaseOfferingRequest.Builder.() -> Unit): PurchaseOfferingResponse = purchaseOffering(PurchaseOfferingRequest.Builder().apply(block).build())

/**
 * Removes an output from a bridge.
 */
public suspend inline fun MediaConnectClient.removeBridgeOutput(crossinline block: RemoveBridgeOutputRequest.Builder.() -> Unit): RemoveBridgeOutputResponse = removeBridgeOutput(RemoveBridgeOutputRequest.Builder().apply(block).build())

/**
 * Removes a source from a bridge.
 */
public suspend inline fun MediaConnectClient.removeBridgeSource(crossinline block: RemoveBridgeSourceRequest.Builder.() -> Unit): RemoveBridgeSourceResponse = removeBridgeSource(RemoveBridgeSourceRequest.Builder().apply(block).build())

/**
 * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
 */
public suspend inline fun MediaConnectClient.removeFlowMediaStream(crossinline block: RemoveFlowMediaStreamRequest.Builder.() -> Unit): RemoveFlowMediaStreamResponse = removeFlowMediaStream(RemoveFlowMediaStreamRequest.Builder().apply(block).build())

/**
 * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
 */
public suspend inline fun MediaConnectClient.removeFlowOutput(crossinline block: RemoveFlowOutputRequest.Builder.() -> Unit): RemoveFlowOutputResponse = removeFlowOutput(RemoveFlowOutputRequest.Builder().apply(block).build())

/**
 * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
 */
public suspend inline fun MediaConnectClient.removeFlowSource(crossinline block: RemoveFlowSourceRequest.Builder.() -> Unit): RemoveFlowSourceResponse = removeFlowSource(RemoveFlowSourceRequest.Builder().apply(block).build())

/**
 * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
 */
public suspend inline fun MediaConnectClient.removeFlowVpcInterface(crossinline block: RemoveFlowVpcInterfaceRequest.Builder.() -> Unit): RemoveFlowVpcInterfaceResponse = removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.Builder().apply(block).build())

/**
 * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
 */
public suspend inline fun MediaConnectClient.revokeFlowEntitlement(crossinline block: RevokeFlowEntitlementRequest.Builder.() -> Unit): RevokeFlowEntitlementResponse = revokeFlowEntitlement(RevokeFlowEntitlementRequest.Builder().apply(block).build())

/**
 * Starts a flow.
 */
public suspend inline fun MediaConnectClient.startFlow(crossinline block: StartFlowRequest.Builder.() -> Unit): StartFlowResponse = startFlow(StartFlowRequest.Builder().apply(block).build())

/**
 * Stops a flow.
 */
public suspend inline fun MediaConnectClient.stopFlow(crossinline block: StopFlowRequest.Builder.() -> Unit): StopFlowResponse = stopFlow(StopFlowRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
 */
public suspend inline fun MediaConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun MediaConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the bridge.
 */
public suspend inline fun MediaConnectClient.updateBridge(crossinline block: UpdateBridgeRequest.Builder.() -> Unit): UpdateBridgeResponse = updateBridge(UpdateBridgeRequest.Builder().apply(block).build())

/**
 * Updates an existing bridge output.
 */
public suspend inline fun MediaConnectClient.updateBridgeOutput(crossinline block: UpdateBridgeOutputRequest.Builder.() -> Unit): UpdateBridgeOutputResponse = updateBridgeOutput(UpdateBridgeOutputRequest.Builder().apply(block).build())

/**
 * Updates an existing bridge source.
 */
public suspend inline fun MediaConnectClient.updateBridgeSource(crossinline block: UpdateBridgeSourceRequest.Builder.() -> Unit): UpdateBridgeSourceResponse = updateBridgeSource(UpdateBridgeSourceRequest.Builder().apply(block).build())

/**
 * Updates the bridge state.
 */
public suspend inline fun MediaConnectClient.updateBridgeState(crossinline block: UpdateBridgeStateRequest.Builder.() -> Unit): UpdateBridgeStateResponse = updateBridgeState(UpdateBridgeStateRequest.Builder().apply(block).build())

/**
 * Updates an existing flow.
 */
public suspend inline fun MediaConnectClient.updateFlow(crossinline block: UpdateFlowRequest.Builder.() -> Unit): UpdateFlowResponse = updateFlow(UpdateFlowRequest.Builder().apply(block).build())

/**
 * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
 */
public suspend inline fun MediaConnectClient.updateFlowEntitlement(crossinline block: UpdateFlowEntitlementRequest.Builder.() -> Unit): UpdateFlowEntitlementResponse = updateFlowEntitlement(UpdateFlowEntitlementRequest.Builder().apply(block).build())

/**
 * Updates an existing media stream.
 */
public suspend inline fun MediaConnectClient.updateFlowMediaStream(crossinline block: UpdateFlowMediaStreamRequest.Builder.() -> Unit): UpdateFlowMediaStreamResponse = updateFlowMediaStream(UpdateFlowMediaStreamRequest.Builder().apply(block).build())

/**
 * Updates an existing flow output.
 */
public suspend inline fun MediaConnectClient.updateFlowOutput(crossinline block: UpdateFlowOutputRequest.Builder.() -> Unit): UpdateFlowOutputResponse = updateFlowOutput(UpdateFlowOutputRequest.Builder().apply(block).build())

/**
 * Updates the source of a flow.
 */
public suspend inline fun MediaConnectClient.updateFlowSource(crossinline block: UpdateFlowSourceRequest.Builder.() -> Unit): UpdateFlowSourceResponse = updateFlowSource(UpdateFlowSourceRequest.Builder().apply(block).build())

/**
 * Updates an existing gateway instance.
 */
public suspend inline fun MediaConnectClient.updateGatewayInstance(crossinline block: UpdateGatewayInstanceRequest.Builder.() -> Unit): UpdateGatewayInstanceResponse = updateGatewayInstance(UpdateGatewayInstanceRequest.Builder().apply(block).build())
