// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfigurationRequest
import aws.sdk.kotlin.services.mediaconnect.model.OutputStatus
import aws.sdk.kotlin.services.mediaconnect.model.Protocol
import aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest
import aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFlowOutputOperationSerializer: HttpSerializer.NonStreaming<UpdateFlowOutputRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFlowOutputRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.flowArn) { "flowArn is bound to the URI and must not be null" }
            requireNotNull(input.outputArn) { "outputArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("flows"))
                add(PercentEncoding.SmithyLabel.encode(input.flowArn))
                add(PercentEncoding.Path.encode("outputs"))
                add(PercentEncoding.SmithyLabel.encode(input.outputArn))
            }
        }

        val payload = serializeUpdateFlowOutputOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowOutputOperationBody(context: ExecutionContext, input: UpdateFlowOutputRequest): ByteArray {
    val serializer = JsonSerializer()
    val CIDRALLOWLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cidrAllowList"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destination"))
    val ENCRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryption"))
    val MAXLATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxLatency"))
    val MEDIASTREAMOUTPUTCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mediaStreamOutputConfigurations"))
    val MINLATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minLatency"))
    val NDIPROGRAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ndiProgramName"))
    val NDISPEEDHQQUALITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ndiSpeedHqQuality"))
    val OUTPUTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("outputStatus"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("port"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("protocol"))
    val REMOTEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("remoteId"))
    val SENDERCONTROLPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("senderControlPort"))
    val SENDERIPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("senderIpAddress"))
    val SMOOTHINGLATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("smoothingLatency"))
    val STREAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("streamId"))
    val VPCINTERFACEATTACHMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcInterfaceAttachment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIDRALLOWLIST_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(ENCRYPTION_DESCRIPTOR)
        field(MAXLATENCY_DESCRIPTOR)
        field(MEDIASTREAMOUTPUTCONFIGURATIONS_DESCRIPTOR)
        field(MINLATENCY_DESCRIPTOR)
        field(NDIPROGRAMNAME_DESCRIPTOR)
        field(NDISPEEDHQQUALITY_DESCRIPTOR)
        field(OUTPUTSTATUS_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(REMOTEID_DESCRIPTOR)
        field(SENDERCONTROLPORT_DESCRIPTOR)
        field(SENDERIPADDRESS_DESCRIPTOR)
        field(SMOOTHINGLATENCY_DESCRIPTOR)
        field(STREAMID_DESCRIPTOR)
        field(VPCINTERFACEATTACHMENT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.cidrAllowList != null) {
            listField(CIDRALLOWLIST_DESCRIPTOR) {
                for (el0 in input.cidrAllowList) {
                    serializeString(el0)
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it) }
        input.encryption?.let { field(ENCRYPTION_DESCRIPTOR, it, ::serializeUpdateEncryptionDocument) }
        input.maxLatency?.let { field(MAXLATENCY_DESCRIPTOR, it) }
        if (input.mediaStreamOutputConfigurations != null) {
            listField(MEDIASTREAMOUTPUTCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.mediaStreamOutputConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMediaStreamOutputConfigurationRequestDocument))
                }
            }
        }
        input.minLatency?.let { field(MINLATENCY_DESCRIPTOR, it) }
        input.ndiProgramName?.let { field(NDIPROGRAMNAME_DESCRIPTOR, it) }
        input.ndiSpeedHqQuality?.let { field(NDISPEEDHQQUALITY_DESCRIPTOR, it) }
        input.outputStatus?.let { field(OUTPUTSTATUS_DESCRIPTOR, it.value) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.protocol?.let { field(PROTOCOL_DESCRIPTOR, it.value) }
        input.remoteId?.let { field(REMOTEID_DESCRIPTOR, it) }
        input.senderControlPort?.let { field(SENDERCONTROLPORT_DESCRIPTOR, it) }
        input.senderIpAddress?.let { field(SENDERIPADDRESS_DESCRIPTOR, it) }
        input.smoothingLatency?.let { field(SMOOTHINGLATENCY_DESCRIPTOR, it) }
        input.streamId?.let { field(STREAMID_DESCRIPTOR, it) }
        input.vpcInterfaceAttachment?.let { field(VPCINTERFACEATTACHMENT_DESCRIPTOR, it, ::serializeVpcInterfaceAttachmentDocument) }
    }
    return serializer.toByteArray()
}
