// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.UpdateBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateEgressGatewayBridgeRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig
import aws.sdk.kotlin.services.mediaconnect.model.UpdateIngressGatewayBridgeRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateBridgeOperationSerializer: HttpSerializer.NonStreaming<UpdateBridgeRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateBridgeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.bridgeArn) { "bridgeArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("bridges"))
                add(PercentEncoding.SmithyLabel.encode(input.bridgeArn))
            }
        }

        val payload = serializeUpdateBridgeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBridgeOperationBody(context: ExecutionContext, input: UpdateBridgeRequest): ByteArray {
    val serializer = JsonSerializer()
    val EGRESSGATEWAYBRIDGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("egressGatewayBridge"))
    val INGRESSGATEWAYBRIDGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ingressGatewayBridge"))
    val SOURCEFAILOVERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceFailoverConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EGRESSGATEWAYBRIDGE_DESCRIPTOR)
        field(INGRESSGATEWAYBRIDGE_DESCRIPTOR)
        field(SOURCEFAILOVERCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.egressGatewayBridge?.let { field(EGRESSGATEWAYBRIDGE_DESCRIPTOR, it, ::serializeUpdateEgressGatewayBridgeRequestDocument) }
        input.ingressGatewayBridge?.let { field(INGRESSGATEWAYBRIDGE_DESCRIPTOR, it, ::serializeUpdateIngressGatewayBridgeRequestDocument) }
        input.sourceFailoverConfig?.let { field(SOURCEFAILOVERCONFIG_DESCRIPTOR, it, ::serializeUpdateFailoverConfigDocument) }
    }
    return serializer.toByteArray()
}
