// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for an output.
 */
public class Output private constructor(builder: Builder) {
    /**
     * The ARN of the bridge added to this output.
     */
    public val bridgeArn: kotlin.String? = builder.bridgeArn
    /**
     * The bridge output ports currently in use.
     */
    public val bridgePorts: List<Int>? = builder.bridgePorts
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public val dataTransferSubscriberFeePercent: kotlin.Int? = builder.dataTransferSubscriberFeePercent
    /**
     * A description of the output.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The address where you want to send the output.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    public val encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.encryption
    /**
     * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
     */
    public val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
     */
    public val listenerAddress: kotlin.String? = builder.listenerAddress
    /**
     * The input ARN of the MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
     */
    public val mediaLiveInputArn: kotlin.String? = builder.mediaLiveInputArn
    /**
     * The configuration for each media stream that is associated with the output.
     */
    public val mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = builder.mediaStreamOutputConfigurations
    /**
     * The name of the output. This value must be unique within the current flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the output.
     */
    public val outputArn: kotlin.String? = builder.outputArn
    /**
     * An indication of whether the output is transmitting data or not.
     */
    public val outputStatus: aws.sdk.kotlin.services.mediaconnect.model.OutputStatus? = builder.outputStatus
    /**
     * The IP address of the device that is currently receiving content from this output.
     *
     * + For outputs that use protocols where you specify the destination (such as SRT Caller or Zixi Push), this value matches the configured destination address.
     * + For outputs that use listener protocols (such as SRT Listener), this value shows the address of the connected receiver.
     * + Peer IP addresses aren't available for entitlements, managed MediaLive outputs, NDI outputs, and CDI/ST2110 outputs.
     * + The peer IP address might not be visible for flows that haven't been started yet, or flows that were started before May 2025. In these cases, restart your flow to see the peer IP address.
     */
    public val peerIpAddress: kotlin.String? = builder.peerIpAddress
    /**
     * The port to use when content is distributed to this output.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Attributes related to the transport stream that are used in the output.
     */
    public val transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = builder.transport
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    public val vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Output = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Output(")
        append("bridgeArn=$bridgeArn,")
        append("bridgePorts=$bridgePorts,")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("listenerAddress=$listenerAddress,")
        append("mediaLiveInputArn=$mediaLiveInputArn,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("name=$name,")
        append("outputArn=$outputArn,")
        append("outputStatus=$outputStatus,")
        append("peerIpAddress=$peerIpAddress,")
        append("port=$port,")
        append("transport=$transport,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bridgeArn?.hashCode() ?: 0
        result = 31 * result + (bridgePorts?.hashCode() ?: 0)
        result = 31 * result + (dataTransferSubscriberFeePercent ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (listenerAddress?.hashCode() ?: 0)
        result = 31 * result + (mediaLiveInputArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputArn?.hashCode() ?: 0)
        result = 31 * result + (outputStatus?.hashCode() ?: 0)
        result = 31 * result + (peerIpAddress?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Output

        if (bridgeArn != other.bridgeArn) return false
        if (bridgePorts != other.bridgePorts) return false
        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (listenerAddress != other.listenerAddress) return false
        if (mediaLiveInputArn != other.mediaLiveInputArn) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (name != other.name) return false
        if (outputArn != other.outputArn) return false
        if (outputStatus != other.outputStatus) return false
        if (peerIpAddress != other.peerIpAddress) return false
        if (port != other.port) return false
        if (transport != other.transport) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Output = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the bridge added to this output.
         */
        public var bridgeArn: kotlin.String? = null
        /**
         * The bridge output ports currently in use.
         */
        public var bridgePorts: List<Int>? = null
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        public var dataTransferSubscriberFeePercent: kotlin.Int? = null
        /**
         * A description of the output.
         */
        public var description: kotlin.String? = null
        /**
         * The address where you want to send the output.
         */
        public var destination: kotlin.String? = null
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        public var encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         */
        public var entitlementArn: kotlin.String? = null
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
         */
        public var listenerAddress: kotlin.String? = null
        /**
         * The input ARN of the MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
         */
        public var mediaLiveInputArn: kotlin.String? = null
        /**
         * The configuration for each media stream that is associated with the output.
         */
        public var mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = null
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the output.
         */
        public var outputArn: kotlin.String? = null
        /**
         * An indication of whether the output is transmitting data or not.
         */
        public var outputStatus: aws.sdk.kotlin.services.mediaconnect.model.OutputStatus? = null
        /**
         * The IP address of the device that is currently receiving content from this output.
         *
         * + For outputs that use protocols where you specify the destination (such as SRT Caller or Zixi Push), this value matches the configured destination address.
         * + For outputs that use listener protocols (such as SRT Listener), this value shows the address of the connected receiver.
         * + Peer IP addresses aren't available for entitlements, managed MediaLive outputs, NDI outputs, and CDI/ST2110 outputs.
         * + The peer IP address might not be visible for flows that haven't been started yet, or flows that were started before May 2025. In these cases, restart your flow to see the peer IP address.
         */
        public var peerIpAddress: kotlin.String? = null
        /**
         * The port to use when content is distributed to this output.
         */
        public var port: kotlin.Int? = null
        /**
         * Attributes related to the transport stream that are used in the output.
         */
        public var transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = null
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        public var vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Output) : this() {
            this.bridgeArn = x.bridgeArn
            this.bridgePorts = x.bridgePorts
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.listenerAddress = x.listenerAddress
            this.mediaLiveInputArn = x.mediaLiveInputArn
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.name = x.name
            this.outputArn = x.outputArn
            this.outputStatus = x.outputStatus
            this.peerIpAddress = x.peerIpAddress
            this.port = x.port
            this.transport = x.transport
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Output = Output(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        public fun transport(block: aws.sdk.kotlin.services.mediaconnect.model.Transport.Builder.() -> kotlin.Unit) {
            this.transport = aws.sdk.kotlin.services.mediaconnect.model.Transport.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        public fun vpcInterfaceAttachment(block: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
