// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The media stream that is associated with the output, and the parameters for that association.
 */
public class MediaStreamOutputConfiguration private constructor(builder: Builder) {
    /**
     * The transport parameters that are associated with each outbound media stream.
     */
    public val destinationConfigurations: List<DestinationConfiguration>? = builder.destinationConfigurations
    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    public val encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = builder.encodingName
    /**
     * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
     */
    public val encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters? = builder.encodingParameters
    /**
     * The name of the media stream.
     */
    public val mediaStreamName: kotlin.String? = builder.mediaStreamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamOutputConfiguration(")
        append("destinationConfigurations=$destinationConfigurations,")
        append("encodingName=$encodingName,")
        append("encodingParameters=$encodingParameters,")
        append("mediaStreamName=$mediaStreamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfigurations?.hashCode() ?: 0
        result = 31 * result + (encodingName?.hashCode() ?: 0)
        result = 31 * result + (encodingParameters?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MediaStreamOutputConfiguration

        if (destinationConfigurations != other.destinationConfigurations) return false
        if (encodingName != other.encodingName) return false
        if (encodingParameters != other.encodingParameters) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The transport parameters that are associated with each outbound media stream.
         */
        public var destinationConfigurations: List<DestinationConfiguration>? = null
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        public var encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = null
        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
         */
        public var encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters? = null
        /**
         * The name of the media stream.
         */
        public var mediaStreamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration) : this() {
            this.destinationConfigurations = x.destinationConfigurations
            this.encodingName = x.encodingName
            this.encodingParameters = x.encodingParameters
            this.mediaStreamName = x.mediaStreamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfiguration = MediaStreamOutputConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters] inside the given [block]
         */
        public fun encodingParameters(block: aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters.Builder.() -> kotlin.Unit) {
            this.encodingParameters = aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
