// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
 */
public class IngressGatewayBridge private constructor(builder: Builder) {
    /**
     * The ID of the instance running this bridge.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum expected bitrate (in bps) of the ingress bridge.
     */
    public val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * The maximum number of outputs on the ingress bridge.
     */
    public val maxOutputs: kotlin.Int? = builder.maxOutputs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngressGatewayBridge(")
        append("instanceId=$instanceId,")
        append("maxBitrate=$maxBitrate,")
        append("maxOutputs=$maxOutputs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxOutputs ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngressGatewayBridge

        if (instanceId != other.instanceId) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxOutputs != other.maxOutputs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the instance running this bridge.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum expected bitrate (in bps) of the ingress bridge.
         */
        public var maxBitrate: kotlin.Int? = null
        /**
         * The maximum number of outputs on the ingress bridge.
         */
        public var maxOutputs: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge) : this() {
            this.instanceId = x.instanceId
            this.maxBitrate = x.maxBitrate
            this.maxOutputs = x.maxOutputs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.IngressGatewayBridge = IngressGatewayBridge(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
