// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The transport parameters that you want to associate with an outbound media stream.
 */
public class DestinationConfiguration private constructor(builder: Builder) {
    /**
     * The IP address where you want MediaConnect to send contents of the media stream.
     */
    public val destinationIp: kotlin.String? = builder.destinationIp
    /**
     * The port that you want MediaConnect to use when it distributes the media stream to the output.
     */
    public val destinationPort: kotlin.Int? = builder.destinationPort
    /**
     * The VPC interface that you want to use for the media stream associated with the output.
     */
    public val `interface`: aws.sdk.kotlin.services.mediaconnect.model.Interface? = builder.`interface`
    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS or protocol.
     */
    public val outboundIp: kotlin.String? = builder.outboundIp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.DestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationConfiguration(")
        append("destinationIp=$destinationIp,")
        append("destinationPort=$destinationPort,")
        append("interface=$`interface`,")
        append("outboundIp=$outboundIp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationIp?.hashCode() ?: 0
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (`interface`?.hashCode() ?: 0)
        result = 31 * result + (outboundIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationConfiguration

        if (destinationIp != other.destinationIp) return false
        if (destinationPort != other.destinationPort) return false
        if (`interface` != other.`interface`) return false
        if (outboundIp != other.outboundIp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.DestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IP address where you want MediaConnect to send contents of the media stream.
         */
        public var destinationIp: kotlin.String? = null
        /**
         * The port that you want MediaConnect to use when it distributes the media stream to the output.
         */
        public var destinationPort: kotlin.Int? = null
        /**
         * The VPC interface that you want to use for the media stream associated with the output.
         */
        public var `interface`: aws.sdk.kotlin.services.mediaconnect.model.Interface? = null
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS or protocol.
         */
        public var outboundIp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.DestinationConfiguration) : this() {
            this.destinationIp = x.destinationIp
            this.destinationPort = x.destinationPort
            this.`interface` = x.`interface`
            this.outboundIp = x.outboundIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.DestinationConfiguration = DestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Interface] inside the given [block]
         */
        public fun `interface`(block: aws.sdk.kotlin.services.mediaconnect.model.Interface.Builder.() -> kotlin.Unit) {
            this.`interface` = aws.sdk.kotlin.services.mediaconnect.model.Interface.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
