// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.MonitoringConfig
import aws.sdk.kotlin.services.mediaconnect.model.NdiConfig
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFailoverConfig
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowRequest
import aws.sdk.kotlin.services.mediaconnect.model.UpdateMaintenance
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFlowOperationSerializer: HttpSerializer.NonStreaming<UpdateFlowRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFlowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.flowArn) { "flowArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("flows"))
                add(PercentEncoding.SmithyLabel.encode(input.flowArn))
            }
        }

        val payload = serializeUpdateFlowOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowOperationBody(context: ExecutionContext, input: UpdateFlowRequest): ByteArray {
    val serializer = JsonSerializer()
    val MAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maintenance"))
    val NDICONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ndiConfig"))
    val SOURCEFAILOVERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceFailoverConfig"))
    val SOURCEMONITORINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceMonitoringConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAINTENANCE_DESCRIPTOR)
        field(NDICONFIG_DESCRIPTOR)
        field(SOURCEFAILOVERCONFIG_DESCRIPTOR)
        field(SOURCEMONITORINGCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.maintenance?.let { field(MAINTENANCE_DESCRIPTOR, it, ::serializeUpdateMaintenanceDocument) }
        input.ndiConfig?.let { field(NDICONFIG_DESCRIPTOR, it, ::serializeNdiConfigDocument) }
        input.sourceFailoverConfig?.let { field(SOURCEFAILOVERCONFIG_DESCRIPTOR, it, ::serializeUpdateFailoverConfigDocument) }
        input.sourceMonitoringConfig?.let { field(SOURCEMONITORINGCONFIG_DESCRIPTOR, it, ::serializeMonitoringConfigDocument) }
    }
    return serializer.toByteArray()
}
