// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest
import aws.sdk.kotlin.services.mediaconnect.model.MediaStreamType
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowMediaStreamRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFlowMediaStreamOperationSerializer: HttpSerializer.NonStreaming<UpdateFlowMediaStreamRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFlowMediaStreamRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.flowArn) { "flowArn is bound to the URI and must not be null" }
            requireNotNull(input.mediaStreamName) { "mediaStreamName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("flows"))
                add(PercentEncoding.SmithyLabel.encode(input.flowArn))
                add(PercentEncoding.Path.encode("mediaStreams"))
                add(PercentEncoding.SmithyLabel.encode(input.mediaStreamName))
            }
        }

        val payload = serializeUpdateFlowMediaStreamOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowMediaStreamOperationBody(context: ExecutionContext, input: UpdateFlowMediaStreamRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attributes"))
    val CLOCKRATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("clockRate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MEDIASTREAMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("mediaStreamType"))
    val VIDEOFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("videoFormat"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(CLOCKRATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(MEDIASTREAMTYPE_DESCRIPTOR)
        field(VIDEOFORMAT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributes?.let { field(ATTRIBUTES_DESCRIPTOR, it, ::serializeMediaStreamAttributesRequestDocument) }
        input.clockRate?.let { field(CLOCKRATE_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.mediaStreamType?.let { field(MEDIASTREAMTYPE_DESCRIPTOR, it.value) }
        input.videoFormat?.let { field(VIDEOFORMAT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
