// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateFlowSourceRequest private constructor(builder: Builder) {
    /**
     * The type of encryption that is used on the content ingested from the source.
     */
    public val decryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = builder.decryption
    /**
     * A description of the source. This description is not visible outside of the current Amazon Web Services account.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the entitlement that allows you to subscribe to the flow. The entitlement is set by the content originator, and the ARN is generated as part of the originator's flow.
     */
    public val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The ARN of the flow that you want to update.
     */
    public val flowArn: kotlin.String? = builder.flowArn
    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     */
    public val gatewayBridgeSource: aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayBridgeSourceRequest? = builder.gatewayBridgeSource
    /**
     * The port that the flow listens on for incoming content. If the protocol of the source is Zixi, the port must be set to 2088.
     */
    public val ingestPort: kotlin.Int? = builder.ingestPort
    /**
     * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
     */
    public val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     */
    public val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    public val maxSyncBuffer: kotlin.Int? = builder.maxSyncBuffer
    /**
     * The media stream that is associated with the source, and the parameters for that association.
     */
    public val mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = builder.mediaStreamSourceConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    public val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The protocol that the source uses to deliver the content to MediaConnect.
     *
     * Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
     */
    public val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    public val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * The ARN of the source that you want to update.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The source IP or domain name for SRT-caller protocol.
     */
    public val sourceListenerAddress: kotlin.String? = builder.sourceListenerAddress
    /**
     * Source port for SRT-caller protocol.
     */
    public val sourceListenerPort: kotlin.Int? = builder.sourceListenerPort
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.
     */
    public val streamId: kotlin.String? = builder.streamId
    /**
     * The name of the VPC interface that you want to send your output to.
     */
    public val vpcInterfaceName: kotlin.String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that are allowed to contribute content to your source. Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public val whitelistCidr: kotlin.String? = builder.whitelistCidr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowSourceRequest(")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("flowArn=$flowArn,")
        append("gatewayBridgeSource=$gatewayBridgeSource,")
        append("ingestPort=$ingestPort,")
        append("maxBitrate=$maxBitrate,")
        append("maxLatency=$maxLatency,")
        append("maxSyncBuffer=$maxSyncBuffer,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("minLatency=$minLatency,")
        append("protocol=$protocol,")
        append("senderControlPort=$senderControlPort,")
        append("senderIpAddress=$senderIpAddress,")
        append("sourceArn=$sourceArn,")
        append("sourceListenerAddress=$sourceListenerAddress,")
        append("sourceListenerPort=$sourceListenerPort,")
        append("streamId=$streamId,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = decryption?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayBridgeSource?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (maxSyncBuffer ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceListenerAddress?.hashCode() ?: 0)
        result = 31 * result + (sourceListenerPort ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFlowSourceRequest

        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (flowArn != other.flowArn) return false
        if (gatewayBridgeSource != other.gatewayBridgeSource) return false
        if (ingestPort != other.ingestPort) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxLatency != other.maxLatency) return false
        if (maxSyncBuffer != other.maxSyncBuffer) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (protocol != other.protocol) return false
        if (senderControlPort != other.senderControlPort) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceListenerAddress != other.sourceListenerAddress) return false
        if (sourceListenerPort != other.sourceListenerPort) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of encryption that is used on the content ingested from the source.
         */
        public var decryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = null
        /**
         * A description of the source. This description is not visible outside of the current Amazon Web Services account.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the entitlement that allows you to subscribe to the flow. The entitlement is set by the content originator, and the ARN is generated as part of the originator's flow.
         */
        public var entitlementArn: kotlin.String? = null
        /**
         * The ARN of the flow that you want to update.
         */
        public var flowArn: kotlin.String? = null
        /**
         * The source configuration for cloud flows receiving a stream from a bridge.
         */
        public var gatewayBridgeSource: aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayBridgeSourceRequest? = null
        /**
         * The port that the flow listens on for incoming content. If the protocol of the source is Zixi, the port must be set to 2088.
         */
        public var ingestPort: kotlin.Int? = null
        /**
         * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
         */
        public var maxBitrate: kotlin.Int? = null
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        public var maxLatency: kotlin.Int? = null
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        public var maxSyncBuffer: kotlin.Int? = null
        /**
         * The media stream that is associated with the source, and the parameters for that association.
         */
        public var mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        public var minLatency: kotlin.Int? = null
        /**
         * The protocol that the source uses to deliver the content to MediaConnect.
         *
         * Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         */
        public var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        public var senderControlPort: kotlin.Int? = null
        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         */
        public var senderIpAddress: kotlin.String? = null
        /**
         * The ARN of the source that you want to update.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The source IP or domain name for SRT-caller protocol.
         */
        public var sourceListenerAddress: kotlin.String? = null
        /**
         * Source port for SRT-caller protocol.
         */
        public var sourceListenerPort: kotlin.Int? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.
         */
        public var streamId: kotlin.String? = null
        /**
         * The name of the VPC interface that you want to send your output to.
         */
        public var vpcInterfaceName: kotlin.String? = null
        /**
         * The range of IP addresses that are allowed to contribute content to your source. Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        public var whitelistCidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest) : this() {
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.flowArn = x.flowArn
            this.gatewayBridgeSource = x.gatewayBridgeSource
            this.ingestPort = x.ingestPort
            this.maxBitrate = x.maxBitrate
            this.maxLatency = x.maxLatency
            this.maxSyncBuffer = x.maxSyncBuffer
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.minLatency = x.minLatency
            this.protocol = x.protocol
            this.senderControlPort = x.senderControlPort
            this.senderIpAddress = x.senderIpAddress
            this.sourceArn = x.sourceArn
            this.sourceListenerAddress = x.sourceListenerAddress
            this.sourceListenerPort = x.sourceListenerPort
            this.streamId = x.streamId
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest = UpdateFlowSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption] inside the given [block]
         */
        public fun decryption(block: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.Builder.() -> kotlin.Unit) {
            this.decryption = aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayBridgeSourceRequest] inside the given [block]
         */
        public fun gatewayBridgeSource(block: aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayBridgeSourceRequest.Builder.() -> kotlin.Unit) {
            this.gatewayBridgeSource = aws.sdk.kotlin.services.mediaconnect.model.UpdateGatewayBridgeSourceRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
