// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings for a flow entitlement.
 */
public class Entitlement private constructor(builder: Builder) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public val dataTransferSubscriberFeePercent: kotlin.Int? = builder.dataTransferSubscriberFeePercent
    /**
     * A description of the entitlement.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of encryption that will be used on the output that is associated with this entitlement.
     */
    public val encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.encryption
    /**
     * The ARN of the entitlement.
     */
    public val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * An indication of whether the entitlement is enabled.
     */
    public val entitlementStatus: aws.sdk.kotlin.services.mediaconnect.model.EntitlementStatus? = builder.entitlementStatus
    /**
     * The name of the entitlement.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
     */
    public val subscribers: List<String>? = builder.subscribers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Entitlement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entitlement(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("description=$description,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("entitlementStatus=$entitlementStatus,")
        append("name=$name,")
        append("subscribers=$subscribers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (entitlementStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (subscribers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entitlement

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (description != other.description) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (entitlementStatus != other.entitlementStatus) return false
        if (name != other.name) return false
        if (subscribers != other.subscribers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Entitlement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        public var dataTransferSubscriberFeePercent: kotlin.Int? = null
        /**
         * A description of the entitlement.
         */
        public var description: kotlin.String? = null
        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         */
        public var encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * The ARN of the entitlement.
         */
        public var entitlementArn: kotlin.String? = null
        /**
         * An indication of whether the entitlement is enabled.
         */
        public var entitlementStatus: aws.sdk.kotlin.services.mediaconnect.model.EntitlementStatus? = null
        /**
         * The name of the entitlement.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
         */
        public var subscribers: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Entitlement) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.description = x.description
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.entitlementStatus = x.entitlementStatus
            this.name = x.name
            this.subscribers = x.subscribers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Entitlement = Entitlement(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
