// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A request to add an output to a flow.
 */
public class AddOutputRequest private constructor(builder: Builder) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * A description of the output. This description appears only on the Audit Manager console and will not be seen by the end user.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The IP address from which video will be sent to output destinations.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
     */
    public val encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.encryption
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     */
    public val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    public val mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = builder.mediaStreamOutputConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    public val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The name of the output. This value must be unique within the current flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A suffix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect uses the output name.
     */
    public val ndiProgramName: kotlin.String? = builder.ndiProgramName
    /**
     * A quality setting for the NDI Speed HQ encoder.
     */
    public val ndiSpeedHqQuality: kotlin.Int? = builder.ndiSpeedHqQuality
    /**
     * An indication of whether the new output should be enabled or disabled as soon as it is created. If you don't specify the outputStatus field in your request, MediaConnect sets it to ENABLED.
     */
    public val outputStatus: aws.sdk.kotlin.services.mediaconnect.model.OutputStatus? = builder.outputStatus
    /**
     * The port to use when content is distributed to this output.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for the output.
     *
     * Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
     */
    public val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull output stream.
     */
    public val remoteId: kotlin.String? = builder.remoteId
    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public val senderControlPort: kotlin.Int? = builder.senderControlPort
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public val smoothingLatency: kotlin.Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.
     */
    public val streamId: kotlin.String? = builder.streamId
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    public val vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddOutputRequest(")
        append("cidrAllowList=$cidrAllowList,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("maxLatency=$maxLatency,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("minLatency=$minLatency,")
        append("name=$name,")
        append("ndiProgramName=$ndiProgramName,")
        append("ndiSpeedHqQuality=$ndiSpeedHqQuality,")
        append("outputStatus=$outputStatus,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("senderControlPort=$senderControlPort,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ndiProgramName?.hashCode() ?: 0)
        result = 31 * result + (ndiSpeedHqQuality ?: 0)
        result = 31 * result + (outputStatus?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (senderControlPort ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddOutputRequest

        if (cidrAllowList != other.cidrAllowList) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (maxLatency != other.maxLatency) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (name != other.name) return false
        if (ndiProgramName != other.ndiProgramName) return false
        if (ndiSpeedHqQuality != other.ndiSpeedHqQuality) return false
        if (outputStatus != other.outputStatus) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (senderControlPort != other.senderControlPort) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        public var cidrAllowList: List<String>? = null
        /**
         * A description of the output. This description appears only on the Audit Manager console and will not be seen by the end user.
         */
        public var description: kotlin.String? = null
        /**
         * The IP address from which video will be sent to output destinations.
         */
        public var destination: kotlin.String? = null
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
         */
        public var encryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        public var maxLatency: kotlin.Int? = null
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         */
        public var mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        public var minLatency: kotlin.Int? = null
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        public var name: kotlin.String? = null
        /**
         * A suffix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect uses the output name.
         */
        public var ndiProgramName: kotlin.String? = null
        /**
         * A quality setting for the NDI Speed HQ encoder.
         */
        public var ndiSpeedHqQuality: kotlin.Int? = null
        /**
         * An indication of whether the new output should be enabled or disabled as soon as it is created. If you don't specify the outputStatus field in your request, MediaConnect sets it to ENABLED.
         */
        public var outputStatus: aws.sdk.kotlin.services.mediaconnect.model.OutputStatus? = null
        /**
         * The port to use when content is distributed to this output.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol to use for the output.
         *
         * Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         */
        public var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The remote ID for the Zixi-pull output stream.
         */
        public var remoteId: kotlin.String? = null
        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         */
        public var senderControlPort: kotlin.Int? = null
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        public var smoothingLatency: kotlin.Int? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based streams.
         */
        public var streamId: kotlin.String? = null
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        public var vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.maxLatency = x.maxLatency
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.minLatency = x.minLatency
            this.name = x.name
            this.ndiProgramName = x.ndiProgramName
            this.ndiSpeedHqQuality = x.ndiSpeedHqQuality
            this.outputStatus = x.outputStatus
            this.port = x.port
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.senderControlPort = x.senderControlPort
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.AddOutputRequest = AddOutputRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        public fun vpcInterfaceAttachment(block: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
