// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.transform

import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class MeterUsageOperationSerializer: HttpSerialize<MeterUsageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: MeterUsageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeMeterUsageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        return builder
    }
}

private fun serializeMeterUsageOperationBody(context: ExecutionContext, input: MeterUsageRequest): ByteArray {
    val serializer = JsonSerializer()
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val PRODUCTCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductCode"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Timestamp"))
    val USAGEALLOCATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UsageAllocations"))
    val USAGEDIMENSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UsageDimension"))
    val USAGEQUANTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("UsageQuantity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DRYRUN_DESCRIPTOR)
        field(PRODUCTCODE_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
        field(USAGEALLOCATIONS_DESCRIPTOR)
        field(USAGEDIMENSION_DESCRIPTOR)
        field(USAGEQUANTITY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.productCode?.let { field(PRODUCTCODE_DESCRIPTOR, it) }
        input.timestamp?.let { field(TIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.usageAllocations != null) {
            listField(USAGEALLOCATIONS_DESCRIPTOR) {
                for (el0 in input.usageAllocations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUsageAllocationDocument))
                }
            }
        }
        input.usageDimension?.let { field(USAGEDIMENSION_DESCRIPTOR, it) }
        input.usageQuantity?.let { field(USAGEQUANTITY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
