// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model



/**
 * A UsageRecordResult indicates the status of a given UsageRecord processed by
 * BatchMeterUsage.
 */
class UsageRecordResult private constructor(builder: BuilderImpl) {
    /**
     * The MeteringRecordId is a unique identifier for this metering event.
     */
    val meteringRecordId: String? = builder.meteringRecordId
    /**
     * The UsageRecordResult Status indicates the status of an individual UsageRecord
     * processed by BatchMeterUsage.
     * Success- The UsageRecord was accepted and honored by
     * BatchMeterUsage.
     * CustomerNotSubscribed- The CustomerIdentifier specified is
     * not subscribed to your product. The UsageRecord was not honored. Future
     * UsageRecords for this customer will fail until the customer subscribes to your
     * product.
     * DuplicateRecord- Indicates that the UsageRecord was invalid
     * and not honored. A previously metered UsageRecord had the same customer,
     * dimension, and time, but a different quantity.
     */
    val status: UsageRecordResultStatus? = builder.status
    /**
     * The UsageRecord that was part of the BatchMeterUsage request.
     */
    val usageRecord: UsageRecord? = builder.usageRecord

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageRecordResult = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecordResult(")
        append("meteringRecordId=$meteringRecordId,")
        append("status=$status,")
        append("usageRecord=$usageRecord)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meteringRecordId?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (usageRecord?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageRecordResult

        if (meteringRecordId != other.meteringRecordId) return false
        if (status != other.status) return false
        if (usageRecord != other.usageRecord) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageRecordResult = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageRecordResult
        /**
         * The MeteringRecordId is a unique identifier for this metering event.
         */
        fun meteringRecordId(meteringRecordId: String): FluentBuilder
        /**
         * The UsageRecordResult Status indicates the status of an individual UsageRecord
         * processed by BatchMeterUsage.
         * Success- The UsageRecord was accepted and honored by
         * BatchMeterUsage.
         * CustomerNotSubscribed- The CustomerIdentifier specified is
         * not subscribed to your product. The UsageRecord was not honored. Future
         * UsageRecords for this customer will fail until the customer subscribes to your
         * product.
         * DuplicateRecord- Indicates that the UsageRecord was invalid
         * and not honored. A previously metered UsageRecord had the same customer,
         * dimension, and time, but a different quantity.
         */
        fun status(status: UsageRecordResultStatus): FluentBuilder
        /**
         * The UsageRecord that was part of the BatchMeterUsage request.
         */
        fun usageRecord(usageRecord: UsageRecord): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The MeteringRecordId is a unique identifier for this metering event.
         */
        var meteringRecordId: String?
        /**
         * The UsageRecordResult Status indicates the status of an individual UsageRecord
         * processed by BatchMeterUsage.
         * Success- The UsageRecord was accepted and honored by
         * BatchMeterUsage.
         * CustomerNotSubscribed- The CustomerIdentifier specified is
         * not subscribed to your product. The UsageRecord was not honored. Future
         * UsageRecords for this customer will fail until the customer subscribes to your
         * product.
         * DuplicateRecord- Indicates that the UsageRecord was invalid
         * and not honored. A previously metered UsageRecord had the same customer,
         * dimension, and time, but a different quantity.
         */
        var status: UsageRecordResultStatus?
        /**
         * The UsageRecord that was part of the BatchMeterUsage request.
         */
        var usageRecord: UsageRecord?

        fun build(): UsageRecordResult
        /**
         * construct an [aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord] inside the given [block]
         */
        fun usageRecord(block: UsageRecord.DslBuilder.() -> kotlin.Unit) {
            this.usageRecord = UsageRecord.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meteringRecordId: String? = null
        override var status: UsageRecordResultStatus? = null
        override var usageRecord: UsageRecord? = null

        constructor(x: UsageRecordResult) : this() {
            this.meteringRecordId = x.meteringRecordId
            this.status = x.status
            this.usageRecord = x.usageRecord
        }

        override fun build(): UsageRecordResult = UsageRecordResult(this)
        override fun meteringRecordId(meteringRecordId: String): FluentBuilder = apply { this.meteringRecordId = meteringRecordId }
        override fun status(status: UsageRecordResultStatus): FluentBuilder = apply { this.status = status }
        override fun usageRecord(usageRecord: UsageRecord): FluentBuilder = apply { this.usageRecord = usageRecord }
    }
}
