// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A UsageRecord indicates a quantity of usage for a given product, customer,
 * dimension and time.
 * Multiple requests with the same UsageRecords as input will be deduplicated to
 * prevent double charges.
 */
class UsageRecord private constructor(builder: BuilderImpl) {
    /**
     * The CustomerIdentifier is obtained through the ResolveCustomer operation and
     * represents an individual buyer in your application.
     */
    val customerIdentifier: String? = builder.customerIdentifier
    /**
     * During the process of registering a product on AWS Marketplace, up to eight
     * dimensions are specified. These represent different units of value in your
     * application.
     */
    val dimension: String? = builder.dimension
    /**
     * The quantity of usage consumed by the customer for the given dimension and time.
     * Defaults to 0 if not specified.
     */
    val quantity: Int? = builder.quantity
    /**
     * Timestamp, in UTC, for which the usage is being reported.
     * Your application can meter usage for up to one hour in the past. Make sure the
     * timestamp value is not before the start of the software usage.
     */
    val timestamp: Instant? = builder.timestamp
    /**
     * The set of UsageAllocations to submit. The sum of all UsageAllocation quantities
     * must equal the Quantity of the UsageRecord.
     */
    val usageAllocations: List<UsageAllocation>? = builder.usageAllocations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageRecord = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecord(")
        append("customerIdentifier=$customerIdentifier,")
        append("dimension=$dimension,")
        append("quantity=$quantity,")
        append("timestamp=$timestamp,")
        append("usageAllocations=$usageAllocations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerIdentifier?.hashCode() ?: 0
        result = 31 * result + (dimension?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (usageAllocations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageRecord

        if (customerIdentifier != other.customerIdentifier) return false
        if (dimension != other.dimension) return false
        if (quantity != other.quantity) return false
        if (timestamp != other.timestamp) return false
        if (usageAllocations != other.usageAllocations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageRecord = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageRecord
        /**
         * The CustomerIdentifier is obtained through the ResolveCustomer operation and
         * represents an individual buyer in your application.
         */
        fun customerIdentifier(customerIdentifier: String): FluentBuilder
        /**
         * During the process of registering a product on AWS Marketplace, up to eight
         * dimensions are specified. These represent different units of value in your
         * application.
         */
        fun dimension(dimension: String): FluentBuilder
        /**
         * The quantity of usage consumed by the customer for the given dimension and time.
         * Defaults to 0 if not specified.
         */
        fun quantity(quantity: Int): FluentBuilder
        /**
         * Timestamp, in UTC, for which the usage is being reported.
         * Your application can meter usage for up to one hour in the past. Make sure the
         * timestamp value is not before the start of the software usage.
         */
        fun timestamp(timestamp: Instant): FluentBuilder
        /**
         * The set of UsageAllocations to submit. The sum of all UsageAllocation quantities
         * must equal the Quantity of the UsageRecord.
         */
        fun usageAllocations(usageAllocations: List<UsageAllocation>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The CustomerIdentifier is obtained through the ResolveCustomer operation and
         * represents an individual buyer in your application.
         */
        var customerIdentifier: String?
        /**
         * During the process of registering a product on AWS Marketplace, up to eight
         * dimensions are specified. These represent different units of value in your
         * application.
         */
        var dimension: String?
        /**
         * The quantity of usage consumed by the customer for the given dimension and time.
         * Defaults to 0 if not specified.
         */
        var quantity: Int?
        /**
         * Timestamp, in UTC, for which the usage is being reported.
         * Your application can meter usage for up to one hour in the past. Make sure the
         * timestamp value is not before the start of the software usage.
         */
        var timestamp: Instant?
        /**
         * The set of UsageAllocations to submit. The sum of all UsageAllocation quantities
         * must equal the Quantity of the UsageRecord.
         */
        var usageAllocations: List<UsageAllocation>?

        fun build(): UsageRecord
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customerIdentifier: String? = null
        override var dimension: String? = null
        override var quantity: Int? = null
        override var timestamp: Instant? = null
        override var usageAllocations: List<UsageAllocation>? = null

        constructor(x: UsageRecord) : this() {
            this.customerIdentifier = x.customerIdentifier
            this.dimension = x.dimension
            this.quantity = x.quantity
            this.timestamp = x.timestamp
            this.usageAllocations = x.usageAllocations
        }

        override fun build(): UsageRecord = UsageRecord(this)
        override fun customerIdentifier(customerIdentifier: String): FluentBuilder = apply { this.customerIdentifier = customerIdentifier }
        override fun dimension(dimension: String): FluentBuilder = apply { this.dimension = dimension }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
        override fun timestamp(timestamp: Instant): FluentBuilder = apply { this.timestamp = timestamp }
        override fun usageAllocations(usageAllocations: List<UsageAllocation>): FluentBuilder = apply { this.usageAllocations = usageAllocations }
    }
}
