// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model



/**
 * Usage allocations allow you to split usage into buckets by tags.
 * Each UsageAllocation indicates the usage quantity for a specific set of tags.
 */
class UsageAllocation private constructor(builder: BuilderImpl) {
    /**
     * The total quantity allocated to this bucket of usage.
     */
    val allocatedUsageQuantity: Int? = builder.allocatedUsageQuantity
    /**
     * The set of tags that define the bucket of usage. For the bucket of items with no
     * tags, this parameter can be left out.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageAllocation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageAllocation(")
        append("allocatedUsageQuantity=$allocatedUsageQuantity,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedUsageQuantity ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageAllocation

        if (allocatedUsageQuantity != other.allocatedUsageQuantity) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageAllocation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageAllocation
        /**
         * The total quantity allocated to this bucket of usage.
         */
        fun allocatedUsageQuantity(allocatedUsageQuantity: Int): FluentBuilder
        /**
         * The set of tags that define the bucket of usage. For the bucket of items with no
         * tags, this parameter can be left out.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total quantity allocated to this bucket of usage.
         */
        var allocatedUsageQuantity: Int?
        /**
         * The set of tags that define the bucket of usage. For the bucket of items with no
         * tags, this parameter can be left out.
         */
        var tags: List<Tag>?

        fun build(): UsageAllocation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocatedUsageQuantity: Int? = null
        override var tags: List<Tag>? = null

        constructor(x: UsageAllocation) : this() {
            this.allocatedUsageQuantity = x.allocatedUsageQuantity
            this.tags = x.tags
        }

        override fun build(): UsageAllocation = UsageAllocation(this)
        override fun allocatedUsageQuantity(allocatedUsageQuantity: Int): FluentBuilder = apply { this.allocatedUsageQuantity = allocatedUsageQuantity }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
