// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.time.Instant

class MeterUsageRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the permissions required for the action, but does not make
     * the request. If you have the permissions, the request returns DryRunOperation;
     * otherwise, it returns UnauthorizedException. Defaults to false if not
     * specified.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Product code is used to uniquely identify a product in AWS Marketplace. The product
     * code should be the same as the one used during the publishing of a new
     * product.
     */
    val productCode: String? = builder.productCode
    /**
     * Timestamp, in UTC, for which the usage is being reported. Your application can
     * meter usage for up to one hour in the past. Make sure the timestamp value is not before
     * the start of the software usage.
     */
    val timestamp: Instant? = builder.timestamp
    /**
     * The set of UsageAllocations to submit.
     * The sum of all UsageAllocation quantities must equal the
     * UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
     * unique set of tags (include no tags).
     */
    val usageAllocations: List<UsageAllocation>? = builder.usageAllocations
    /**
     * It will be one of the fcp dimension name provided during the publishing of the
     * product.
     */
    val usageDimension: String? = builder.usageDimension
    /**
     * Consumption value for the hour. Defaults to 0 if not
     * specified.
     */
    val usageQuantity: Int? = builder.usageQuantity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MeterUsageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MeterUsageRequest(")
        append("dryRun=$dryRun,")
        append("productCode=$productCode,")
        append("timestamp=$timestamp,")
        append("usageAllocations=$usageAllocations,")
        append("usageDimension=$usageDimension,")
        append("usageQuantity=$usageQuantity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (usageAllocations?.hashCode() ?: 0)
        result = 31 * result + (usageDimension?.hashCode() ?: 0)
        result = 31 * result + (usageQuantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MeterUsageRequest

        if (dryRun != other.dryRun) return false
        if (productCode != other.productCode) return false
        if (timestamp != other.timestamp) return false
        if (usageAllocations != other.usageAllocations) return false
        if (usageDimension != other.usageDimension) return false
        if (usageQuantity != other.usageQuantity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MeterUsageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MeterUsageRequest
        /**
         * Checks whether you have the permissions required for the action, but does not make
         * the request. If you have the permissions, the request returns DryRunOperation;
         * otherwise, it returns UnauthorizedException. Defaults to false if not
         * specified.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product
         * code should be the same as the one used during the publishing of a new
         * product.
         */
        fun productCode(productCode: String): FluentBuilder
        /**
         * Timestamp, in UTC, for which the usage is being reported. Your application can
         * meter usage for up to one hour in the past. Make sure the timestamp value is not before
         * the start of the software usage.
         */
        fun timestamp(timestamp: Instant): FluentBuilder
        /**
         * The set of UsageAllocations to submit.
         * The sum of all UsageAllocation quantities must equal the
         * UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
         * unique set of tags (include no tags).
         */
        fun usageAllocations(usageAllocations: List<UsageAllocation>): FluentBuilder
        /**
         * It will be one of the fcp dimension name provided during the publishing of the
         * product.
         */
        fun usageDimension(usageDimension: String): FluentBuilder
        /**
         * Consumption value for the hour. Defaults to 0 if not
         * specified.
         */
        fun usageQuantity(usageQuantity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the permissions required for the action, but does not make
         * the request. If you have the permissions, the request returns DryRunOperation;
         * otherwise, it returns UnauthorizedException. Defaults to false if not
         * specified.
         */
        var dryRun: Boolean?
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product
         * code should be the same as the one used during the publishing of a new
         * product.
         */
        var productCode: String?
        /**
         * Timestamp, in UTC, for which the usage is being reported. Your application can
         * meter usage for up to one hour in the past. Make sure the timestamp value is not before
         * the start of the software usage.
         */
        var timestamp: Instant?
        /**
         * The set of UsageAllocations to submit.
         * The sum of all UsageAllocation quantities must equal the
         * UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
         * unique set of tags (include no tags).
         */
        var usageAllocations: List<UsageAllocation>?
        /**
         * It will be one of the fcp dimension name provided during the publishing of the
         * product.
         */
        var usageDimension: String?
        /**
         * Consumption value for the hour. Defaults to 0 if not
         * specified.
         */
        var usageQuantity: Int?

        fun build(): MeterUsageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var productCode: String? = null
        override var timestamp: Instant? = null
        override var usageAllocations: List<UsageAllocation>? = null
        override var usageDimension: String? = null
        override var usageQuantity: Int? = null

        constructor(x: MeterUsageRequest) : this() {
            this.dryRun = x.dryRun
            this.productCode = x.productCode
            this.timestamp = x.timestamp
            this.usageAllocations = x.usageAllocations
            this.usageDimension = x.usageDimension
            this.usageQuantity = x.usageQuantity
        }

        override fun build(): MeterUsageRequest = MeterUsageRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun productCode(productCode: String): FluentBuilder = apply { this.productCode = productCode }
        override fun timestamp(timestamp: Instant): FluentBuilder = apply { this.timestamp = timestamp }
        override fun usageAllocations(usageAllocations: List<UsageAllocation>): FluentBuilder = apply { this.usageAllocations = usageAllocations }
        override fun usageDimension(usageDimension: String): FluentBuilder = apply { this.usageDimension = usageDimension }
        override fun usageQuantity(usageQuantity: Int): FluentBuilder = apply { this.usageQuantity = usageQuantity }
    }
}
