// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model



/**
 * Contains the UsageRecords processed by BatchMeterUsage and any records that have
 * failed due to transient error.
 */
class BatchMeterUsageResponse private constructor(builder: BuilderImpl) {
    /**
     * Contains all UsageRecords processed by BatchMeterUsage. These records were either
     * honored by AWS Marketplace Metering Service or were invalid.
     */
    val results: List<UsageRecordResult>? = builder.results
    /**
     * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a
     * list of UsageRecords. You can retry the failed request by making another BatchMeterUsage
     * call with this list as input in the BatchMeterUsageRequest.
     */
    val unprocessedRecords: List<UsageRecord>? = builder.unprocessedRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchMeterUsageResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchMeterUsageResponse(")
        append("results=$results,")
        append("unprocessedRecords=$unprocessedRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = results?.hashCode() ?: 0
        result = 31 * result + (unprocessedRecords?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchMeterUsageResponse

        if (results != other.results) return false
        if (unprocessedRecords != other.unprocessedRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchMeterUsageResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchMeterUsageResponse
        /**
         * Contains all UsageRecords processed by BatchMeterUsage. These records were either
         * honored by AWS Marketplace Metering Service or were invalid.
         */
        fun results(results: List<UsageRecordResult>): FluentBuilder
        /**
         * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a
         * list of UsageRecords. You can retry the failed request by making another BatchMeterUsage
         * call with this list as input in the BatchMeterUsageRequest.
         */
        fun unprocessedRecords(unprocessedRecords: List<UsageRecord>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains all UsageRecords processed by BatchMeterUsage. These records were either
         * honored by AWS Marketplace Metering Service or were invalid.
         */
        var results: List<UsageRecordResult>?
        /**
         * Contains all UsageRecords that were not processed by BatchMeterUsage. This is a
         * list of UsageRecords. You can retry the failed request by making another BatchMeterUsage
         * call with this list as input in the BatchMeterUsageRequest.
         */
        var unprocessedRecords: List<UsageRecord>?

        fun build(): BatchMeterUsageResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var results: List<UsageRecordResult>? = null
        override var unprocessedRecords: List<UsageRecord>? = null

        constructor(x: BatchMeterUsageResponse) : this() {
            this.results = x.results
            this.unprocessedRecords = x.unprocessedRecords
        }

        override fun build(): BatchMeterUsageResponse = BatchMeterUsageResponse(this)
        override fun results(results: List<UsageRecordResult>): FluentBuilder = apply { this.results = results }
        override fun unprocessedRecords(unprocessedRecords: List<UsageRecord>): FluentBuilder = apply { this.unprocessedRecords = unprocessedRecords }
    }
}
