// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model



/**
 * A BatchMeterUsageRequest contains UsageRecords, which indicate quantities of usage
 * within your application.
 */
class BatchMeterUsageRequest private constructor(builder: BuilderImpl) {
    /**
     * Product code is used to uniquely identify a product in AWS Marketplace. The product
     * code should be the same as the one used during the publishing of a new
     * product.
     */
    val productCode: String? = builder.productCode
    /**
     * The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
     * a time.
     */
    val usageRecords: List<UsageRecord>? = builder.usageRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchMeterUsageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchMeterUsageRequest(")
        append("productCode=$productCode,")
        append("usageRecords=$usageRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = productCode?.hashCode() ?: 0
        result = 31 * result + (usageRecords?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchMeterUsageRequest

        if (productCode != other.productCode) return false
        if (usageRecords != other.usageRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchMeterUsageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchMeterUsageRequest
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product
         * code should be the same as the one used during the publishing of a new
         * product.
         */
        fun productCode(productCode: String): FluentBuilder
        /**
         * The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
         * a time.
         */
        fun usageRecords(usageRecords: List<UsageRecord>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product
         * code should be the same as the one used during the publishing of a new
         * product.
         */
        var productCode: String?
        /**
         * The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
         * a time.
         */
        var usageRecords: List<UsageRecord>?

        fun build(): BatchMeterUsageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var productCode: String? = null
        override var usageRecords: List<UsageRecord>? = null

        constructor(x: BatchMeterUsageRequest) : this() {
            this.productCode = x.productCode
            this.usageRecords = x.usageRecords
        }

        override fun build(): BatchMeterUsageRequest = BatchMeterUsageRequest(this)
        override fun productCode(productCode: String): FluentBuilder = apply { this.productCode = productCode }
        override fun usageRecords(usageRecords: List<UsageRecord>): FluentBuilder = apply { this.usageRecords = usageRecords }
    }
}
