// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.marketplacemetering.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.marketplacemetering.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS Marketplace Metering Service</fullname>
 * This reference provides descriptions of the low-level AWS Marketplace Metering
 * Service API.
 * AWS Marketplace sellers can use this API to submit usage data for custom usage
 * dimensions.
 * For information on the permissions you need to use this API, see
 * <a href="https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html">AWS Marketing metering and entitlement API permissions in the AWS Marketplace Seller Guide.
 * Submitting Metering Records
 * MeterUsage- Submits the metering record for a Marketplace
 * product. MeterUsage is called from an EC2 instance or a container running on EKS
 * or ECS.
 * BatchMeterUsage- Submits the metering record for a set of
 * customers. BatchMeterUsage is called from a software-as-a-service (SaaS)
 * application.
 * Accepting New Customers
 * ResolveCustomer- Called by a SaaS application during the
 * registration process. When a buyer visits your website during the registration
 * process, the buyer submits a Registration Token through the browser. The
 * Registration Token is resolved through this API to obtain a CustomerIdentifier
 * and Product Code.
 * Entitlement and Metering for Paid Container Products
 * Paid container software products sold through AWS Marketplace must
 * integrate with the AWS Marketplace Metering Service and call the RegisterUsage
 * operation for software entitlement and metering. Free and BYOL products for
 * Amazon ECS or Amazon EKS aren't required to call RegisterUsage, but you can do
 * so if you want to receive usage data in your seller reports. For more
 * information on using the RegisterUsage operation, see <a href="https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html">Container-Based Products.
 * BatchMeterUsage API calls are captured by AWS CloudTrail. You can use Cloudtrail to
 * verify that the SaaS metering records that you sent are accurate by searching for
 * records with the eventName of BatchMeterUsage. You can also use CloudTrail to audit
 * records over time. For more information, see the
 * <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html">AWS CloudTrail User Guide
 * .
 */
interface MarketplaceMeteringClient : SdkClient {

    override val serviceName: String
        get() = "Marketplace Metering"
    /**
     * MarketplaceMeteringClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): MarketplaceMeteringClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultMarketplaceMeteringClient(config)
        }

        operator fun invoke(config: Config): MarketplaceMeteringClient = DefaultMarketplaceMeteringClient(config)

        /**
         * Construct a [MarketplaceMeteringClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): MarketplaceMeteringClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return MarketplaceMeteringClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to
     * post metering records for a set of customers.
     * For identical requests, the API is idempotent; requests can be retried with the
     * same records or a subset of the input records.
     * Every request to BatchMeterUsage is for one product. If you need to meter usage for
     * multiple products, you must make multiple calls to BatchMeterUsage.
     * BatchMeterUsage can process up to 25 UsageRecords at a time.
     * A UsageRecord can optionally include multiple usage allocations, to provide customers
     * with usagedata split into buckets by tags that you define (or allow the customer to
     * define).
     * BatchMeterUsage requests must be less than 1MB in size.
     */
    suspend fun batchMeterUsage(input: BatchMeterUsageRequest): BatchMeterUsageResponse

    /**
     * BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to
     * post metering records for a set of customers.
     * For identical requests, the API is idempotent; requests can be retried with the
     * same records or a subset of the input records.
     * Every request to BatchMeterUsage is for one product. If you need to meter usage for
     * multiple products, you must make multiple calls to BatchMeterUsage.
     * BatchMeterUsage can process up to 25 UsageRecords at a time.
     * A UsageRecord can optionally include multiple usage allocations, to provide customers
     * with usagedata split into buckets by tags that you define (or allow the customer to
     * define).
     * BatchMeterUsage requests must be less than 1MB in size.
     */
    suspend fun batchMeterUsage(block: BatchMeterUsageRequest.DslBuilder.() -> Unit) = batchMeterUsage(BatchMeterUsageRequest.builder().apply(block).build())

    /**
     * API to emit metering records. For identical requests, the API is idempotent. It
     * simply returns the metering record ID.
     * MeterUsage is authenticated on the buyer's AWS account using credentials from the
     * EC2 instance, ECS task, or EKS pod.
     * MeterUsage can optionally include multiple usage allocations, to provide customers
     * with usage data split into buckets by tags that you define (or allow the customer to
     * define).
     */
    suspend fun meterUsage(input: MeterUsageRequest): MeterUsageResponse

    /**
     * API to emit metering records. For identical requests, the API is idempotent. It
     * simply returns the metering record ID.
     * MeterUsage is authenticated on the buyer's AWS account using credentials from the
     * EC2 instance, ECS task, or EKS pod.
     * MeterUsage can optionally include multiple usage allocations, to provide customers
     * with usage data split into buckets by tags that you define (or allow the customer to
     * define).
     */
    suspend fun meterUsage(block: MeterUsageRequest.DslBuilder.() -> Unit) = meterUsage(MeterUsageRequest.builder().apply(block).build())

    /**
     * Paid container software products sold through AWS Marketplace must integrate with
     * the AWS Marketplace Metering Service and call the RegisterUsage operation for software
     * entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't
     * required to call RegisterUsage, but you may choose to do so if you would like to receive
     * usage data in your seller reports. The sections below explain the behavior of
     * RegisterUsage. RegisterUsage performs two primary functions: metering and
     * entitlement.
     * Entitlement: RegisterUsage allows you to verify that the
     * customer running your paid software is subscribed to your product on AWS
     * Marketplace, enabling you to guard against unauthorized use. Your container
     * image that integrates with RegisterUsage is only required to guard against
     * unauthorized use at container startup, as such a
     * CustomerNotSubscribedException/PlatformNotSupportedException will only be thrown
     * on the initial call to RegisterUsage. Subsequent calls from the same Amazon ECS
     * task instance (e.g. task-id) or Amazon EKS pod will not throw a
     * CustomerNotSubscribedException, even if the customer unsubscribes while the
     * Amazon ECS task or Amazon EKS pod is still running.
     * Metering: RegisterUsage meters software use per ECS task,
     * per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum
     * of 1 minute of usage applies to tasks that are short lived. For example, if a
     * customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured
     * as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10
     * cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for
     * software use is automatically handled by the AWS Marketplace Metering Control
     * Plane -- your software is not required to perform any metering specific actions,
     * other than call RegisterUsage once for metering of software use to commence. The
     * AWS Marketplace Metering Control Plane will also continue to bill customers for
     * running ECS tasks and Amazon EKS pods, regardless of the customers subscription
     * state, removing the need for your software to perform entitlement checks at
     * runtime.
     */
    suspend fun registerUsage(input: RegisterUsageRequest): RegisterUsageResponse

    /**
     * Paid container software products sold through AWS Marketplace must integrate with
     * the AWS Marketplace Metering Service and call the RegisterUsage operation for software
     * entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't
     * required to call RegisterUsage, but you may choose to do so if you would like to receive
     * usage data in your seller reports. The sections below explain the behavior of
     * RegisterUsage. RegisterUsage performs two primary functions: metering and
     * entitlement.
     * Entitlement: RegisterUsage allows you to verify that the
     * customer running your paid software is subscribed to your product on AWS
     * Marketplace, enabling you to guard against unauthorized use. Your container
     * image that integrates with RegisterUsage is only required to guard against
     * unauthorized use at container startup, as such a
     * CustomerNotSubscribedException/PlatformNotSupportedException will only be thrown
     * on the initial call to RegisterUsage. Subsequent calls from the same Amazon ECS
     * task instance (e.g. task-id) or Amazon EKS pod will not throw a
     * CustomerNotSubscribedException, even if the customer unsubscribes while the
     * Amazon ECS task or Amazon EKS pod is still running.
     * Metering: RegisterUsage meters software use per ECS task,
     * per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum
     * of 1 minute of usage applies to tasks that are short lived. For example, if a
     * customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured
     * as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10
     * cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for
     * software use is automatically handled by the AWS Marketplace Metering Control
     * Plane -- your software is not required to perform any metering specific actions,
     * other than call RegisterUsage once for metering of software use to commence. The
     * AWS Marketplace Metering Control Plane will also continue to bill customers for
     * running ECS tasks and Amazon EKS pods, regardless of the customers subscription
     * state, removing the need for your software to perform entitlement checks at
     * runtime.
     */
    suspend fun registerUsage(block: RegisterUsageRequest.DslBuilder.() -> Unit) = registerUsage(RegisterUsageRequest.builder().apply(block).build())

    /**
     * ResolveCustomer is called by a SaaS application during the registration process.
     * When a buyer visits your website during the registration process, the buyer submits a
     * registration token through their browser. The registration token is resolved through
     * this API to obtain a CustomerIdentifier and product code.
     */
    suspend fun resolveCustomer(input: ResolveCustomerRequest): ResolveCustomerResponse

    /**
     * ResolveCustomer is called by a SaaS application during the registration process.
     * When a buyer visits your website during the registration process, the buyer submits a
     * registration token through their browser. The registration token is resolved through
     * this API to obtain a CustomerIdentifier and product code.
     */
    suspend fun resolveCustomer(block: ResolveCustomerRequest.DslBuilder.() -> Unit) = resolveCustomer(ResolveCustomerRequest.builder().apply(block).build())
}
