// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.serde

import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResolveCustomerOperationDeserializer: HttpDeserializer.NonStreaming<ResolveCustomerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ResolveCustomerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwResolveCustomerError(context, call, payload)
        }
        val builder = ResolveCustomerResponse.Builder()

        if (payload != null) {
            deserializeResolveCustomerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwResolveCustomerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledApiException" -> DisabledApiExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResolveCustomerOperationBody(builder: ResolveCustomerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMERAWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomerAWSAccountId"))
    val CUSTOMERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomerIdentifier"))
    val PRODUCTCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERAWSACCOUNTID_DESCRIPTOR)
        field(CUSTOMERIDENTIFIER_DESCRIPTOR)
        field(PRODUCTCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMERAWSACCOUNTID_DESCRIPTOR.index -> builder.customerAwsAccountId = deserializeString()
                CUSTOMERIDENTIFIER_DESCRIPTOR.index -> builder.customerIdentifier = deserializeString()
                PRODUCTCODE_DESCRIPTOR.index -> builder.productCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
