// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.serde

import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MeterUsageOperationDeserializer: HttpDeserializer.NonStreaming<MeterUsageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): MeterUsageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwMeterUsageError(context, call, payload)
        }
        val builder = MeterUsageResponse.Builder()

        if (payload != null) {
            deserializeMeterUsageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwMeterUsageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateRequestException" -> DuplicateRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEndpointRegionException" -> InvalidEndpointRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUsageAllocationsException" -> InvalidUsageAllocationsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUsageDimensionException" -> InvalidUsageDimensionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TimestampOutOfBoundsException" -> TimestampOutOfBoundsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CustomerNotEntitledException" -> CustomerNotEntitledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidProductCodeException" -> InvalidProductCodeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMeterUsageOperationBody(builder: MeterUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METERINGRECORDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MeteringRecordId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METERINGRECORDID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METERINGRECORDID_DESCRIPTOR.index -> builder.meteringRecordId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
