// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.serde

import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord
import aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchMeterUsageOperationDeserializer: HttpDeserializer.NonStreaming<BatchMeterUsageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchMeterUsageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchMeterUsageError(context, call, payload)
        }
        val builder = BatchMeterUsageResponse.Builder()

        if (payload != null) {
            deserializeBatchMeterUsageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchMeterUsageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledApiException" -> DisabledApiExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUsageAllocationsException" -> InvalidUsageAllocationsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUsageDimensionException" -> InvalidUsageDimensionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCustomerIdentifierException" -> InvalidCustomerIdentifierExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TimestampOutOfBoundsException" -> TimestampOutOfBoundsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidProductCodeException" -> InvalidProductCodeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchMeterUsageOperationBody(builder: BatchMeterUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Results"))
    val UNPROCESSEDRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedRecords"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULTS_DESCRIPTOR)
        field(UNPROCESSEDRECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULTS_DESCRIPTOR.index -> builder.results =
                    deserializer.deserializeList(RESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageRecordResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageRecordResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDRECORDS_DESCRIPTOR.index -> builder.unprocessedRecords =
                    deserializer.deserializeList(UNPROCESSEDRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
