// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `UsageRecordResult` indicates the status of a given `UsageRecord` processed by `BatchMeterUsage`.
 */
public class UsageRecordResult private constructor(builder: Builder) {
    /**
     * The `MeteringRecordId` is a unique identifier for this metering event.
     */
    public val meteringRecordId: kotlin.String? = builder.meteringRecordId
    /**
     * The `UsageRecordResult``Status` indicates the status of an individual `UsageRecord` processed by `BatchMeterUsage`.
     * + *Success*- The `UsageRecord` was accepted and honored by `BatchMeterUsage`.
     * + *CustomerNotSubscribed*- The `CustomerIdentifier` specified is not able to use your product. The `UsageRecord` was not honored. There are three causes for this result:
     *    + The customer identifier is invalid.
     *    + The customer identifier provided in the metering record does not have an active agreement or subscription with this product. Future `UsageRecords` for this customer will fail until the customer subscribes to your product.
     *    + The customer's AWS account was suspended.
     * + *DuplicateRecord*- Indicates that the `UsageRecord` was invalid and not honored. A previously metered `UsageRecord` had the same customer, dimension, and time, but a different quantity.
     */
    public val status: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResultStatus? = builder.status
    /**
     * The `UsageRecord` that was part of the `BatchMeterUsage` request.
     */
    public val usageRecord: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord? = builder.usageRecord

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecordResult(")
        append("meteringRecordId=$meteringRecordId,")
        append("status=$status,")
        append("usageRecord=$usageRecord")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = meteringRecordId?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (usageRecord?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageRecordResult

        if (meteringRecordId != other.meteringRecordId) return false
        if (status != other.status) return false
        if (usageRecord != other.usageRecord) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `MeteringRecordId` is a unique identifier for this metering event.
         */
        public var meteringRecordId: kotlin.String? = null
        /**
         * The `UsageRecordResult``Status` indicates the status of an individual `UsageRecord` processed by `BatchMeterUsage`.
         * + *Success*- The `UsageRecord` was accepted and honored by `BatchMeterUsage`.
         * + *CustomerNotSubscribed*- The `CustomerIdentifier` specified is not able to use your product. The `UsageRecord` was not honored. There are three causes for this result:
         *    + The customer identifier is invalid.
         *    + The customer identifier provided in the metering record does not have an active agreement or subscription with this product. Future `UsageRecords` for this customer will fail until the customer subscribes to your product.
         *    + The customer's AWS account was suspended.
         * + *DuplicateRecord*- Indicates that the `UsageRecord` was invalid and not honored. A previously metered `UsageRecord` had the same customer, dimension, and time, but a different quantity.
         */
        public var status: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResultStatus? = null
        /**
         * The `UsageRecord` that was part of the `BatchMeterUsage` request.
         */
        public var usageRecord: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult) : this() {
            this.meteringRecordId = x.meteringRecordId
            this.status = x.status
            this.usageRecord = x.usageRecord
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult = UsageRecordResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord] inside the given [block]
         */
        public fun usageRecord(block: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord.Builder.() -> kotlin.Unit) {
            this.usageRecord = aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
