// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Usage allocations allow you to split usage into buckets by tags.
 *
 * Each `UsageAllocation` indicates the usage quantity for a specific set of tags.
 */
public class UsageAllocation private constructor(builder: Builder) {
    /**
     * The total quantity allocated to this bucket of usage.
     */
    public val allocatedUsageQuantity: kotlin.Int = requireNotNull(builder.allocatedUsageQuantity) { "A non-null value must be provided for allocatedUsageQuantity" }
    /**
     * The set of tags that define the bucket of usage. For the bucket of items with no tags, this parameter can be left out.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacemetering.model.UsageAllocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageAllocation(")
        append("allocatedUsageQuantity=$allocatedUsageQuantity,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedUsageQuantity
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageAllocation

        if (allocatedUsageQuantity != other.allocatedUsageQuantity) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacemetering.model.UsageAllocation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total quantity allocated to this bucket of usage.
         */
        public var allocatedUsageQuantity: kotlin.Int? = null
        /**
         * The set of tags that define the bucket of usage. For the bucket of items with no tags, this parameter can be left out.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacemetering.model.UsageAllocation) : this() {
            this.allocatedUsageQuantity = x.allocatedUsageQuantity
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacemetering.model.UsageAllocation = UsageAllocation(this)

        internal fun correctErrors(): Builder {
            if (allocatedUsageQuantity == null) allocatedUsageQuantity = 0
            return this
        }
    }
}
