// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the `UsageRecords` processed by `BatchMeterUsage` and any records that have failed due to transient error.
 */
public class BatchMeterUsageResponse private constructor(builder: Builder) {
    /**
     * Contains all `UsageRecords` processed by `BatchMeterUsage`. These records were either honored by AWS Marketplace Metering Service or were invalid. Invalid records should be fixed before being resubmitted.
     */
    public val results: List<UsageRecordResult>? = builder.results
    /**
     * Contains all `UsageRecords` that were not processed by `BatchMeterUsage`. This is a list of `UsageRecords`. You can retry the failed request by making another `BatchMeterUsage` call with this list as input in the `BatchMeterUsageRequest`.
     */
    public val unprocessedRecords: List<UsageRecord>? = builder.unprocessedRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchMeterUsageResponse(")
        append("results=$results,")
        append("unprocessedRecords=$unprocessedRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = results?.hashCode() ?: 0
        result = 31 * result + (unprocessedRecords?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchMeterUsageResponse

        if (results != other.results) return false
        if (unprocessedRecords != other.unprocessedRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains all `UsageRecords` processed by `BatchMeterUsage`. These records were either honored by AWS Marketplace Metering Service or were invalid. Invalid records should be fixed before being resubmitted.
         */
        public var results: List<UsageRecordResult>? = null
        /**
         * Contains all `UsageRecords` that were not processed by `BatchMeterUsage`. This is a list of `UsageRecords`. You can retry the failed request by making another `BatchMeterUsage` call with this list as input in the `BatchMeterUsageRequest`.
         */
        public var unprocessedRecords: List<UsageRecord>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse) : this() {
            this.results = x.results
            this.unprocessedRecords = x.unprocessedRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse = BatchMeterUsageResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
