// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.marketplacemetering.auth.DefaultMarketplaceMeteringAuthSchemeProvider
import aws.sdk.kotlin.services.marketplacemetering.auth.MarketplaceMeteringAuthSchemeProvider
import aws.sdk.kotlin.services.marketplacemetering.endpoints.DefaultMarketplaceMeteringEndpointProvider
import aws.sdk.kotlin.services.marketplacemetering.endpoints.MarketplaceMeteringEndpointParameters
import aws.sdk.kotlin.services.marketplacemetering.endpoints.MarketplaceMeteringEndpointProvider
import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.RegisterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.RegisterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerRequest
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Marketplace Metering"
public const val SdkVersion: String = "1.4.5"
public const val ServiceApiVersion: String = "2016-01-14"

/**
 * # AWS Marketplace Metering Service
 * This reference provides descriptions of the low-level AWS Marketplace Metering Service API.
 *
 * AWS Marketplace sellers can use this API to submit usage data for custom usage dimensions.
 *
 * For information on the permissions you need to use this API, see [AWS Marketplace metering and entitlement API permissions](https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html) in the *AWS Marketplace Seller Guide.*
 *
 * **Submitting Metering Records**
 * + *MeterUsage* - Submits the metering record for an AWS Marketplace product. `MeterUsage` is called from an EC2 instance or a container running on EKS or ECS.
 * + *BatchMeterUsage* - Submits the metering record for a set of customers. `BatchMeterUsage` is called from a software-as-a-service (SaaS) application.
 *
 * **Accepting New Customers**
 * + *ResolveCustomer* - Called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a Registration Token through the browser. The Registration Token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
 *
 * **Entitlement and Metering for Paid Container Products**
 * + Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you can do so if you want to receive usage data in your seller reports. For more information on using the `RegisterUsage` operation, see [Container-Based Products](https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html).
 *
 * `BatchMeterUsage` API calls are captured by AWS CloudTrail. You can use Cloudtrail to verify that the SaaS metering records that you sent are accurate by searching for records with the `eventName` of `BatchMeterUsage`. You can also use CloudTrail to audit records over time. For more information, see the *[AWS CloudTrail User Guide](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html).*
 */
public interface MarketplaceMeteringClient : SdkClient {
    /**
     * MarketplaceMeteringClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MarketplaceMeteringClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MarketplaceMetering",
                "MARKETPLACE_METERING",
                "marketplace_metering",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MarketplaceMeteringClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MarketplaceMeteringClient = DefaultMarketplaceMeteringClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MarketplaceMeteringEndpointProvider = builder.endpointProvider ?: DefaultMarketplaceMeteringEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MarketplaceMeteringAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMarketplaceMeteringAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Marketplace Metering"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MarketplaceMeteringEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MarketplaceMeteringAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * `BatchMeterUsage` is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers.
     *
     * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the input records.
     *
     * Every request to `BatchMeterUsage` is for one product. If you need to meter usage for multiple products, you must make multiple calls to `BatchMeterUsage`.
     *
     * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
     *
     * `BatchMeterUsage` can process up to 25 `UsageRecords` at a time.
     *
     * A `UsageRecord` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
     *
     * `BatchMeterUsage` returns a list of `UsageRecordResult` objects, showing the result for each `UsageRecord`, as well as a list of `UnprocessedRecords`, indicating errors in the service side that you should retry.
     *
     * `BatchMeterUsage` requests must be less than 1MB in size.
     *
     * For an example of using `BatchMeterUsage`, see [ BatchMeterUsage code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-batchmeterusage-example) in the *AWS Marketplace Seller Guide*.
     */
    public suspend fun batchMeterUsage(input: BatchMeterUsageRequest): BatchMeterUsageResponse

    /**
     * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.
     *
     * `MeterUsage` is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS pod.
     *
     * `MeterUsage` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
     *
     * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
     */
    public suspend fun meterUsage(input: MeterUsageRequest): MeterUsageResponse

    /**
     * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of `RegisterUsage`. `RegisterUsage` performs two primary functions: metering and entitlement.
     * + *Entitlement*: `RegisterUsage` allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that integrates with `RegisterUsage` is only required to guard against unauthorized use at container startup, as such a `CustomerNotSubscribedException` or `PlatformNotSupportedException` will only be thrown on the initial call to `RegisterUsage`. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a `CustomerNotSubscribedException`, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS pod is still running.
     * + *Metering*: `RegisterUsage` meters software use per ECS task, per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software is not required to perform any metering specific actions, other than call `RegisterUsage` once for metering of software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your software to perform entitlement checks at runtime.
     */
    public suspend fun registerUsage(input: RegisterUsageRequest): RegisterUsageResponse

    /**
     * `ResolveCustomer` is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
     *
     * The API needs to called from the seller account id used to publish the SaaS application to successfully resolve the token.
     *
     * For an example of using `ResolveCustomer`, see [ ResolveCustomer code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-resolvecustomer-example) in the *AWS Marketplace Seller Guide*.
     */
    public suspend fun resolveCustomer(input: ResolveCustomerRequest): ResolveCustomerResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MarketplaceMeteringClient.withConfig(block: MarketplaceMeteringClient.Config.Builder.() -> Unit): MarketplaceMeteringClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMarketplaceMeteringClient(newConfig)
}

/**
 * `BatchMeterUsage` is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers.
 *
 * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the input records.
 *
 * Every request to `BatchMeterUsage` is for one product. If you need to meter usage for multiple products, you must make multiple calls to `BatchMeterUsage`.
 *
 * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
 *
 * `BatchMeterUsage` can process up to 25 `UsageRecords` at a time.
 *
 * A `UsageRecord` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
 *
 * `BatchMeterUsage` returns a list of `UsageRecordResult` objects, showing the result for each `UsageRecord`, as well as a list of `UnprocessedRecords`, indicating errors in the service side that you should retry.
 *
 * `BatchMeterUsage` requests must be less than 1MB in size.
 *
 * For an example of using `BatchMeterUsage`, see [ BatchMeterUsage code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-batchmeterusage-example) in the *AWS Marketplace Seller Guide*.
 */
public suspend inline fun MarketplaceMeteringClient.batchMeterUsage(crossinline block: BatchMeterUsageRequest.Builder.() -> Unit): BatchMeterUsageResponse = batchMeterUsage(BatchMeterUsageRequest.Builder().apply(block).build())

/**
 * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.
 *
 * `MeterUsage` is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS pod.
 *
 * `MeterUsage` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
 *
 * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
 */
public suspend inline fun MarketplaceMeteringClient.meterUsage(crossinline block: MeterUsageRequest.Builder.() -> Unit): MeterUsageResponse = meterUsage(MeterUsageRequest.Builder().apply(block).build())

/**
 * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of `RegisterUsage`. `RegisterUsage` performs two primary functions: metering and entitlement.
 * + *Entitlement*: `RegisterUsage` allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that integrates with `RegisterUsage` is only required to guard against unauthorized use at container startup, as such a `CustomerNotSubscribedException` or `PlatformNotSupportedException` will only be thrown on the initial call to `RegisterUsage`. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a `CustomerNotSubscribedException`, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS pod is still running.
 * + *Metering*: `RegisterUsage` meters software use per ECS task, per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software is not required to perform any metering specific actions, other than call `RegisterUsage` once for metering of software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your software to perform entitlement checks at runtime.
 */
public suspend inline fun MarketplaceMeteringClient.registerUsage(crossinline block: RegisterUsageRequest.Builder.() -> Unit): RegisterUsageResponse = registerUsage(RegisterUsageRequest.Builder().apply(block).build())

/**
 * `ResolveCustomer` is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
 *
 * The API needs to called from the seller account id used to publish the SaaS application to successfully resolve the token.
 *
 * For an example of using `ResolveCustomer`, see [ ResolveCustomer code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-resolvecustomer-example) in the *AWS Marketplace Seller Guide*.
 */
public suspend inline fun MarketplaceMeteringClient.resolveCustomer(crossinline block: ResolveCustomerRequest.Builder.() -> Unit): ResolveCustomerResponse = resolveCustomer(ResolveCustomerRequest.Builder().apply(block).build())
