// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResolveCustomerOperationDeserializer: HttpDeserialize<ResolveCustomerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ResolveCustomerResponse {
        if (!response.status.isSuccess()) {
            throwResolveCustomerError(context, response)
        }
        val builder = ResolveCustomerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeResolveCustomerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwResolveCustomerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledApiException" -> DisabledApiExceptionDeserializer().deserialize(context, wrappedResponse)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResolveCustomerOperationBody(builder: ResolveCustomerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMERAWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomerAWSAccountId"))
    val CUSTOMERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomerIdentifier"))
    val PRODUCTCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERAWSACCOUNTID_DESCRIPTOR)
        field(CUSTOMERIDENTIFIER_DESCRIPTOR)
        field(PRODUCTCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMERAWSACCOUNTID_DESCRIPTOR.index -> builder.customerAwsAccountId = deserializeString()
                CUSTOMERIDENTIFIER_DESCRIPTOR.index -> builder.customerIdentifier = deserializeString()
                PRODUCTCODE_DESCRIPTOR.index -> builder.productCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
