// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.RegisterUsageResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class RegisterUsageOperationDeserializer: HttpDeserialize<RegisterUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterUsageResponse {
        if (!response.status.isSuccess()) {
            throwRegisterUsageError(context, response)
        }
        val builder = RegisterUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterUsageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterUsageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomerNotEntitledException" -> CustomerNotEntitledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledApiException" -> DisabledApiExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidProductCodeException" -> InvalidProductCodeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPublicKeyVersionException" -> InvalidPublicKeyVersionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRegionException" -> InvalidRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "PlatformNotSupportedException" -> PlatformNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterUsageOperationBody(builder: RegisterUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PUBLICKEYROTATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("PublicKeyRotationTimestamp"))
    val SIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Signature"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PUBLICKEYROTATIONTIMESTAMP_DESCRIPTOR)
        field(SIGNATURE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PUBLICKEYROTATIONTIMESTAMP_DESCRIPTOR.index -> builder.publicKeyRotationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                SIGNATURE_DESCRIPTOR.index -> builder.signature = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
