// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MeterUsageOperationDeserializer: HttpDeserialize<MeterUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): MeterUsageResponse {
        if (!response.status.isSuccess()) {
            throwMeterUsageError(context, response)
        }
        val builder = MeterUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeMeterUsageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwMeterUsageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomerNotEntitledException" -> CustomerNotEntitledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateRequestException" -> DuplicateRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEndpointRegionException" -> InvalidEndpointRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidProductCodeException" -> InvalidProductCodeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUsageAllocationsException" -> InvalidUsageAllocationsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUsageDimensionException" -> InvalidUsageDimensionExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "TimestampOutOfBoundsException" -> TimestampOutOfBoundsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMeterUsageOperationBody(builder: MeterUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METERINGRECORDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MeteringRecordId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METERINGRECORDID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METERINGRECORDID_DESCRIPTOR.index -> builder.meteringRecordId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
