// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.marketplacemetering.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.marketplacemetering.endpoints.EndpointProvider
import aws.sdk.kotlin.services.marketplacemetering.model.*
import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.MeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.RegisterUsageRequest
import aws.sdk.kotlin.services.marketplacemetering.model.RegisterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerRequest
import aws.sdk.kotlin.services.marketplacemetering.model.ResolveCustomerResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * # AWS Marketplace Metering Service
 * This reference provides descriptions of the low-level AWS Marketplace Metering Service API.
 *
 * AWS Marketplace sellers can use this API to submit usage data for custom usage dimensions.
 *
 * For information on the permissions you need to use this API, see [AWS Marketplace metering and entitlement API permissions](https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html) in the *AWS Marketplace Seller Guide.*
 *
 * **Submitting Metering Records**
 * + *MeterUsage* - Submits the metering record for an AWS Marketplace product. `MeterUsage` is called from an EC2 instance or a container running on EKS or ECS.
 * + *BatchMeterUsage* - Submits the metering record for a set of customers. `BatchMeterUsage` is called from a software-as-a-service (SaaS) application.
 *
 * **Accepting New Customers**
 * + *ResolveCustomer* - Called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a Registration Token through the browser. The Registration Token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
 *
 * **Entitlement and Metering for Paid Container Products**
 * + Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you can do so if you want to receive usage data in your seller reports. For more information on using the `RegisterUsage` operation, see [Container-Based Products](https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html).
 *
 * `BatchMeterUsage` API calls are captured by AWS CloudTrail. You can use Cloudtrail to verify that the SaaS metering records that you sent are accurate by searching for records with the `eventName` of `BatchMeterUsage`. You can also use CloudTrail to audit records over time. For more information, see the *[AWS CloudTrail User Guide](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html).*
 */
public interface MarketplaceMeteringClient : SdkClient {

    override val serviceName: String
        get() = "Marketplace Metering"
    /**
     * MarketplaceMeteringClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MarketplaceMeteringClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMarketplaceMeteringClient(config)
        }

        public operator fun invoke(config: Config): MarketplaceMeteringClient = DefaultMarketplaceMeteringClient(config)

        /**
         * Construct a [MarketplaceMeteringClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MarketplaceMeteringClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMarketplaceMeteringClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Marketplace Metering")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * `BatchMeterUsage` is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers.
     *
     * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the input records.
     *
     * Every request to `BatchMeterUsage` is for one product. If you need to meter usage for multiple products, you must make multiple calls to `BatchMeterUsage`.
     *
     * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
     *
     * `BatchMeterUsage` can process up to 25 `UsageRecords` at a time.
     *
     * A `UsageRecord` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
     *
     * `BatchMeterUsage` returns a list of `UsageRecordResult` objects, showing the result for each `UsageRecord`, as well as a list of `UnprocessedRecords`, indicating errors in the service side that you should retry.
     *
     * `BatchMeterUsage` requests must be less than 1MB in size.
     *
     * For an example of using `BatchMeterUsage`, see [ BatchMeterUsage code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-batchmeterusage-example) in the *AWS Marketplace Seller Guide*.
     */
    public suspend fun batchMeterUsage(input: BatchMeterUsageRequest): BatchMeterUsageResponse

    /**
     * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.
     *
     * `MeterUsage` is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS pod.
     *
     * `MeterUsage` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
     *
     * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
     */
    public suspend fun meterUsage(input: MeterUsageRequest): MeterUsageResponse

    /**
     * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of `RegisterUsage`. `RegisterUsage` performs two primary functions: metering and entitlement.
     * + *Entitlement*: `RegisterUsage` allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that integrates with `RegisterUsage` is only required to guard against unauthorized use at container startup, as such a `CustomerNotSubscribedException` or `PlatformNotSupportedException` will only be thrown on the initial call to `RegisterUsage`. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a `CustomerNotSubscribedException`, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS pod is still running.
     * + *Metering*: `RegisterUsage` meters software use per ECS task, per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software is not required to perform any metering specific actions, other than call `RegisterUsage` once for metering of software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your software to perform entitlement checks at runtime.
     */
    public suspend fun registerUsage(input: RegisterUsageRequest): RegisterUsageResponse

    /**
     * `ResolveCustomer` is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
     *
     * The API needs to called from the seller account id used to publish the SaaS application to successfully resolve the token.
     *
     * For an example of using `ResolveCustomer`, see [ ResolveCustomer code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-resolvecustomer-example) in the *AWS Marketplace Seller Guide*.
     */
    public suspend fun resolveCustomer(input: ResolveCustomerRequest): ResolveCustomerResponse
}

/**
 * `BatchMeterUsage` is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers.
 *
 * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the input records.
 *
 * Every request to `BatchMeterUsage` is for one product. If you need to meter usage for multiple products, you must make multiple calls to `BatchMeterUsage`.
 *
 * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
 *
 * `BatchMeterUsage` can process up to 25 `UsageRecords` at a time.
 *
 * A `UsageRecord` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
 *
 * `BatchMeterUsage` returns a list of `UsageRecordResult` objects, showing the result for each `UsageRecord`, as well as a list of `UnprocessedRecords`, indicating errors in the service side that you should retry.
 *
 * `BatchMeterUsage` requests must be less than 1MB in size.
 *
 * For an example of using `BatchMeterUsage`, see [ BatchMeterUsage code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-batchmeterusage-example) in the *AWS Marketplace Seller Guide*.
 */
public suspend inline fun MarketplaceMeteringClient.batchMeterUsage(crossinline block: BatchMeterUsageRequest.Builder.() -> Unit): BatchMeterUsageResponse = batchMeterUsage(BatchMeterUsageRequest.Builder().apply(block).build())

/**
 * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.
 *
 * `MeterUsage` is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS pod.
 *
 * `MeterUsage` can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).
 *
 * Usage records are expected to be submitted as quickly as possible after the event that is being recorded, and are not accepted more than 6 hours after the event.
 */
public suspend inline fun MarketplaceMeteringClient.meterUsage(crossinline block: MeterUsageRequest.Builder.() -> Unit): MeterUsageResponse = meterUsage(MeterUsageRequest.Builder().apply(block).build())

/**
 * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the `RegisterUsage` operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call `RegisterUsage`, but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of `RegisterUsage`. `RegisterUsage` performs two primary functions: metering and entitlement.
 * + *Entitlement*: `RegisterUsage` allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that integrates with `RegisterUsage` is only required to guard against unauthorized use at container startup, as such a `CustomerNotSubscribedException` or `PlatformNotSupportedException` will only be thrown on the initial call to `RegisterUsage`. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a `CustomerNotSubscribedException`, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS pod is still running.
 * + *Metering*: `RegisterUsage` meters software use per ECS task, per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software is not required to perform any metering specific actions, other than call `RegisterUsage` once for metering of software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your software to perform entitlement checks at runtime.
 */
public suspend inline fun MarketplaceMeteringClient.registerUsage(crossinline block: RegisterUsageRequest.Builder.() -> Unit): RegisterUsageResponse = registerUsage(RegisterUsageRequest.Builder().apply(block).build())

/**
 * `ResolveCustomer` is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
 *
 * The API needs to called from the seller account id used to publish the SaaS application to successfully resolve the token.
 *
 * For an example of using `ResolveCustomer`, see [ ResolveCustomer code example](https://docs.aws.amazon.com/marketplace/latest/userguide/saas-code-examples.html#saas-resolvecustomer-example) in the *AWS Marketplace Seller Guide*.
 */
public suspend inline fun MarketplaceMeteringClient.resolveCustomer(crossinline block: ResolveCustomerRequest.Builder.() -> Unit): ResolveCustomerResponse = resolveCustomer(ResolveCustomerRequest.Builder().apply(block).build())
