// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.marketplacemetering.model.BatchMeterUsageResponse
import aws.sdk.kotlin.services.marketplacemetering.model.MarketplaceMeteringException
import aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord
import aws.sdk.kotlin.services.marketplacemetering.model.UsageRecordResult
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchMeterUsageOperationDeserializer: HttpDeserialize<BatchMeterUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchMeterUsageResponse {
        if (!response.status.isSuccess()) {
            throwBatchMeterUsageError(context, response)
        }
        val builder = BatchMeterUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchMeterUsageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchMeterUsageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceMeteringException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledApiException" -> DisabledApiExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCustomerIdentifierException" -> InvalidCustomerIdentifierExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidProductCodeException" -> InvalidProductCodeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUsageAllocationsException" -> InvalidUsageAllocationsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUsageDimensionException" -> InvalidUsageDimensionExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "TimestampOutOfBoundsException" -> TimestampOutOfBoundsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MarketplaceMeteringException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchMeterUsageOperationBody(builder: BatchMeterUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Results"))
    val UNPROCESSEDRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedRecords"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULTS_DESCRIPTOR)
        field(UNPROCESSEDRECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULTS_DESCRIPTOR.index -> builder.results =
                    deserializer.deserializeList(RESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageRecordResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageRecordResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDRECORDS_DESCRIPTOR.index -> builder.unprocessedRecords =
                    deserializer.deserializeList(UNPROCESSEDRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
